/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.client.particle.VaporParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class SimpleDomainEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(SimpleDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_MAX_HEALTH = SynchedEntityData.m_135353_(SimpleDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(SimpleDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_ENLARGEMENT = SynchedEntityData.m_135353_(SimpleDomainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float STRENGTH = 100.0f;
    private static final double X_STEP = 0.025;
    public static final float RADIUS = 1.5f;
    private static final float MAX_RADIUS = 3.5f;
    private static final float DAMAGE = 3.0f;
    private boolean invuln = false;
    private boolean domainInvuln = false;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    protected SimpleDomainEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public SimpleDomainEntity(LivingEntity owner) {
        super((EntityType)JJKEntities.SIMPLE_DOMAIN.get(), owner.m_9236_());
        this.setOwner(owner);
        this.m_146884_(owner.m_20182_());
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        this.setRadius(Math.min(3.5f, 1.5f * cap.getAbilityPower()));
        this.setMaxHealth(100.0f * cap.getAbilityPower());
        this.setHealth(((Float)this.f_19804_.m_135370_(DATA_MAX_HEALTH)).floatValue());
    }

    public static float getRadius(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return Math.min(3.5f, 1.5f * cap.getAbilityPower());
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue() * (1.0f + this.getEnlargement());
    }

    private void setRadius(float radius) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
    }

    private float getMaxHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_MAX_HEALTH)).floatValue();
    }

    private void setMaxHealth(float maxHealth) {
        this.f_19804_.m_135381_(DATA_MAX_HEALTH, (Object)Float.valueOf(maxHealth));
    }

    private float getHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEALTH)).floatValue();
    }

    private void setHealth(float health) {
        this.f_19804_.m_135381_(DATA_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)health, (float)0.0f, (float)this.getMaxHealth())));
    }

    public boolean m_5825_() {
        return true;
    }

    public float getEnlargement() {
        return ((Float)this.f_19804_.m_135370_(DATA_ENLARGEMENT)).floatValue();
    }

    public void setEnlargement(float enlargement) {
        this.f_19804_.m_135381_(DATA_ENLARGEMENT, (Object)Float.valueOf(enlargement));
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        float radius = (float)((double)this.getRadius() * 2.0);
        return EntityDimensions.m_20398_((float)radius, (float)radius);
    }

    public boolean canEnlarge() {
        LivingEntity owner = this.getOwner();
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return this.getEnlargement() < Math.min(3.5f, 1.5f * cap.getAbilityPower()) / 2.0f;
    }

    public void enlarge() {
        this.setEnlargement(this.getEnlargement() + 0.1f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_MAX_HEALTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ENLARGEMENT, (Object)Float.valueOf(0.0f));
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount, boolean isDomainAttack) {
        LivingEntity attacker;
        if (!isDomainAttack && this.invuln) {
            return false;
        }
        if (isDomainAttack && this.domainInvuln) {
            return false;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) == owner) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (isDomainAttack) {
            this.domainInvuln = true;
            cap.delayTickEvent(() -> {
                this.domainInvuln = false;
            }, 10);
        }
        if (!isDomainAttack) {
            this.invuln = true;
            cap.delayTickEvent(() -> {
                this.invuln = false;
            }, 5);
        }
        this.setHealth(this.getHealth() - pAmount);
        return true;
    }

    public void m_8119_() {
        if (this.getHealth() == 0.0f) {
            this.m_146870_();
            return;
        }
        this.m_6210_();
        LivingEntity owner = this.getOwner();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.SIMPLE_DOMAIN.get()))) {
            this.m_146870_();
        } else if (owner != null) {
            super.m_8119_();
            this.m_146884_(owner.m_20182_());
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                for (DomainExpansionEntity domain : VeilHandler.getDomains(level2, owner.m_20183_())) {
                    if (!domain.checkSureHitEffect()) continue;
                    LivingEntity target = domain.getOwner();
                    float baseDMG = 3.0f;
                    if (domain.ability == JJKAbilities.UNLIMITED_VOID.get() || domain.ability == JJKAbilities.SELF_EMBODIMENT_OF_PERFECTION.get()) {
                        baseDMG *= 0.5f;
                    }
                    if (domain.ability == JJKAbilities.MALEVOLENT_SHRINE.get()) {
                        baseDMG *= 12.0f;
                    }
                    if (target == null) continue;
                    ISorcererData targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    this.hurt(JJKDamageSources.indirectJujutsuAttack(domain, target, null), baseDMG * (1.0f + Math.max(0.0f, targetCap.getAbilityPower() - ownerCap.getAbilityPower())), true);
                }
            }
            float factor = this.getHealth() / this.getMaxHealth() * 2.0f;
            double circumference = Math.PI * 2 * (double)factor;
            VaporParticle.VaporParticleOptions particle = new VaporParticle.VaporParticleOptions(ParticleColors.SIMPLE_DOMAIN, (float)((double)this.getRadius() * 0.25), 1.0f, true, 1);
            float radius = this.getRadius();
            for (double phi = 0.0; phi < circumference; phi += circumference / (double)radius * 0.025) {
                double x = this.m_20185_() + (double)this.getRadius() * Math.cos(phi);
                double y = this.m_20186_();
                double z = this.m_20189_() + (double)this.getRadius() * Math.sin(phi);
                this.m_9236_().m_7106_((ParticleOptions)particle, x, y, z, 0.0, HelperMethods.RANDOM.m_188500_(), 0.0);
            }
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128350_("enlargement", this.getEnlargement());
        pCompound.m_128350_("radius", this.getRadius());
        pCompound.m_128350_("max_health", this.getMaxHealth());
        pCompound.m_128350_("health", this.getHealth());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.setRadius(pCompound.m_128457_("radius"));
        this.setEnlargement(pCompound.m_128457_("enlargement"));
        this.setMaxHealth(pCompound.m_128457_("max_health"));
        this.setHealth(pCompound.m_128457_("health"));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

