/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ai.goal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.item.CursedSpiritOrbItem;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.HelperMethods;

public class SorcererGoal
extends Goal {
    private static final int CHANGE_COPIED_TECHNIQUE_INTERVAL = 200;
    private final PathfinderMob mob;
    private long lastCanUseCheck;

    public SorcererGoal(PathfinderMob mob) {
        this.mob = mob;
    }

    public void m_8037_() {
        ArrayList<CursedTechnique> copied;
        List<Ability> abilities = JJKAbilities.getAbilities((LivingEntity)this.mob);
        ISorcererData cap = (ISorcererData)this.mob.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasToggled((Ability)JJKAbilities.RIKA.get()) && (cap.getCurrentCopied() == null || this.mob.f_19797_ % 200 == 0) && !(copied = new ArrayList<CursedTechnique>(cap.getCopied())).isEmpty()) {
            cap.setCurrentCopied((CursedTechnique)((Object)copied.get(HelperMethods.RANDOM.m_188503_(copied.size()))));
        }
        if (cap.hasTechnique(CursedTechnique.CURSE_MANIPULATION)) {
            ItemStack stack;
            LivingEntity target = this.mob.m_5448_();
            if (target != null && HelperMethods.RANDOM.m_188503_(5) == 0) {
                List<AbsorbedCurse> curses = cap.getCurses();
                if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                    ISorcererData targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                    AbsorbedCurse closest = null;
                    for (AbsorbedCurse curse : curses) {
                        float diff = Math.abs(JJKAbilities.getCurseExperience(curse) - targetCap.getExperience());
                        if (closest != null && !(diff < Math.abs(JJKAbilities.getCurseExperience(closest) - targetCap.getExperience()))) continue;
                        closest = curse;
                    }
                    if (closest != null) {
                        JJKAbilities.summonCurse((LivingEntity)this.mob, closest, true);
                    }
                } else if (!curses.isEmpty()) {
                    JJKAbilities.summonCurse((LivingEntity)this.mob, HelperMethods.RANDOM.m_188503_(curses.size()), true);
                }
            }
            if ((stack = this.mob.m_21120_(InteractionHand.MAIN_HAND)).m_150930_((Item)JJKItems.CURSED_SPIRIT_ORB.get())) {
                this.mob.m_5496_(this.mob.m_7866_(stack), 1.0f, 1.0f + (HelperMethods.RANDOM.m_188501_() - HelperMethods.RANDOM.m_188501_()) * 0.4f);
                cap.addCurse(CursedSpiritOrbItem.getAbsorbed(stack));
                this.mob.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        for (Ability ability : abilities) {
            boolean success = ability.shouldTrigger(this.mob, this.mob.m_5448_());
            if (ability.getActivationType((LivingEntity)this.mob) == Ability.ActivationType.TOGGLED) {
                if (success) {
                    if (JJKAbilities.hasToggled((LivingEntity)this.mob, ability)) continue;
                    AbilityHandler.trigger((LivingEntity)this.mob, ability);
                    continue;
                }
                if (!JJKAbilities.hasToggled((LivingEntity)this.mob, ability)) continue;
                AbilityHandler.untrigger((LivingEntity)this.mob, ability);
                return;
            }
            if (ability.getActivationType((LivingEntity)this.mob) == Ability.ActivationType.CHANNELED) {
                if (success) {
                    if (JJKAbilities.isChanneling((LivingEntity)this.mob, ability)) continue;
                    AbilityHandler.trigger((LivingEntity)this.mob, ability);
                    if (ability == JJKAbilities.HEAL.get() || ability == JJKAbilities.RCT1.get() || ability == JJKAbilities.RCT2.get() || ability == JJKAbilities.RCT3.get()) continue;
                    return;
                }
                if (!JJKAbilities.isChanneling((LivingEntity)this.mob, ability)) continue;
                AbilityHandler.untrigger((LivingEntity)this.mob, ability);
                if (ability == JJKAbilities.HEAL.get() || ability == JJKAbilities.RCT1.get() || ability == JJKAbilities.RCT2.get() || ability == JJKAbilities.RCT3.get()) continue;
                return;
            }
            if (!success) continue;
            AbilityHandler.trigger((LivingEntity)this.mob, ability);
            if (ability == JJKAbilities.QUICKDASH.get() || ability == JJKAbilities.DASH.get() || ability == JJKAbilities.SLAM.get() || ability == JJKAbilities.PUNCH.get()) continue;
            return;
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck > 8L) {
            this.lastCanUseCheck = i;
            return true;
        }
        return false;
    }
}

