/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.base.IRightClickInputListener;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DinoCurseEntity
extends CursedSpirit
implements PlayerRideable,
IRightClickInputListener {
    private static final double EXPLOSION_FALL_DISTANCE = 10.0;
    private static final int EXPLOSION_DURATION = 20;
    private static final float EXPLOSION_POWER = 10.0f;
    private static final EntityDataAccessor<Boolean> DATA_SHOOTING = SynchedEntityData.m_135353_(DinoCurseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenLoop("attack.shoot");
    private int riding;

    public DinoCurseEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.SPECIAL_GRADE.getRequiredExperience();
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHOOTING, (Object)false);
    }

    private boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHOOTING);
    }

    private void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(DATA_SHOOTING, (Object)shooting);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        boolean result = super.m_142535_(pFallDistance, pMultiplier, pSource);
        if (result && (double)pFallDistance >= 10.0) {
            ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), this.m_20182_(), 10.0f, 20, (LivingEntity)this, this.m_269291_().m_269333_((LivingEntity)this), false);
        }
        return result;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_() && !this.m_20160_()) {
            this.riding = this.f_19797_;
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.5f;
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20885_ = this.f_20886_ = this.m_146908_();
        this.f_20883_ = this.f_20886_;
        this.f_19859_ = this.f_20886_;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    private PlayState walkRunIdlePredicate(AnimationState<DinoCurseEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue(IDLE);
    }

    private PlayState swingPredicate(AnimationState<DinoCurseEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState shootPredicate(AnimationState<DinoCurseEntity> animationState) {
        if (this.isShooting()) {
            return animationState.setAndContinue(SHOOT);
        }
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Shoot", this::shootPredicate)});
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.setShooting(JJKAbilities.isChanneling((LivingEntity)this, (Ability)JJKAbilities.BLUE_FIRE.get()));
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.BLUE_FIRE.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 35.0);
    }

    @Override
    public void setDown(boolean down) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19797_ - this.riding < 20) {
            return;
        }
        boolean channelling = JJKAbilities.isChanneling((LivingEntity)this, (Ability)JJKAbilities.BLUE_FIRE.get());
        if (down) {
            if (!channelling) {
                AbilityHandler.trigger((LivingEntity)this, (Ability)JJKAbilities.BLUE_FIRE.get());
            }
        } else if (channelling) {
            AbilityHandler.untrigger((LivingEntity)this, (Ability)JJKAbilities.BLUE_FIRE.get());
        }
    }
}

