/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.effect;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.sound.JJKSounds;

public class JacobsLadderEntity
extends JujutsuProjectile {
    private static final float DAMAGE = 10.0f;
    public static final int HITBOX_START = 6;
    public static final int STRIKE_EXPLOSION = 6;
    private static final int STRIKE_LENGTH = 24;
    private int strikeTimeO;
    private int strikeTime;
    private float chant;

    public JacobsLadderEntity(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public JacobsLadderEntity(LivingEntity owner, float power, Vec3 pos, float chant) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.JACOBS_LADDER.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        this.setPower(power);
        this.chant = chant;
        this.m_6034_(pos.f_82479_, pos.f_82480_ + 1.0625, pos.f_82481_);
    }

    public float getStrikeDrawTime(float partialTicks) {
        return this.getActualStrikeTime(partialTicks) / 6.0f;
    }

    public float getStrikeDamageTime(float partialTicks) {
        return (this.getActualStrikeTime(partialTicks) - 6.0f) / 18.0f;
    }

    public boolean isStrikeDrawing(float partialTicks) {
        return this.getActualStrikeTime(partialTicks) < 6.0f;
    }

    public boolean isStriking(float partialTicks) {
        return this.getActualStrikeTime(partialTicks) < 24.0f;
    }

    private float getActualStrikeTime(float delta) {
        return (float)this.strikeTimeO + (float)(this.strikeTime - this.strikeTimeO) * delta;
    }

    @Override
    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.strikeTimeO = this.strikeTime;
        if (this.strikeTime == 0) {
            this.m_5496_((SoundEvent)JJKSounds.JACOBS_CHARGE.get(), 0.8f, 1.0f);
        }
        if (this.strikeTime >= 6) {
            this.hurtEntities(Math.max((double)4.0, (double)(0.2 * (double)this.getPower())));
        }
        this.moveDownToGround();
        if (this.strikeTime >= 24) {
            this.m_146870_();
        } else if (this.strikeTime == 6) {
            this.m_5496_((SoundEvent)JJKSounds.JACOBS_FIRE.get(), 0.8f, 1.0f);
        }
        ++this.strikeTime;
    }

    public void moveDownToGround() {
        BlockHitResult blockHit;
        HitResult hit = this.getHitResult();
        if (hit.m_6662_() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).m_82434_() == Direction.UP) {
            BlockState state = this.m_9236_().m_8055_(blockHit.m_82425_());
            if (this.strikeTime >= 24) {
                this.m_146870_();
            }
            if (state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                this.m_6034_(this.m_20185_(), (float)blockHit.m_82425_().m_123342_() + 1.0625f - 0.5f, this.m_20189_());
            } else {
                this.m_6034_(this.m_20185_(), (float)blockHit.m_82425_().m_123342_() + 1.0625f, this.m_20189_());
            }
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundTeleportEntityPacket((Entity)this));
            }
        }
    }

    public void hurtEntities(double radius) {
        Entity entity = this.m_19749_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        AABB bounds = new AABB(this.m_20185_() - radius, this.m_20186_() - 0.5, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + 40.0, this.m_20189_() + radius);
        List entities = this.m_9236_().m_45933_((Entity)this, bounds);
        double radiusSq = radius * radius;
        ISorcererData selfCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity entity2 : entities) {
            if (entity2 == owner && !selfCap.hasSelfHit() || !(this.getDistanceSqXZToEntity(entity2) < radiusSq)) continue;
            int[] mult = new int[]{1};
            entity2.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                if (cap.hasTrait(Trait.INCARNATED)) {
                    mult[0] = (int)((double)mult[0] * 2.0);
                }
                cap.setDisable((int)(60.0f * this.chant * (float)mult[0]));
                if (cap.hasTechnique(CursedTechnique.BRAIN_TRANSPLANT) && entity2 instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    living.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 10, 0, false, false, false));
                }
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity2;
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
            });
            entity2.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)this, owner, (Ability)JJKAbilities.JACOBS_LADDER.get()), (float)mult[0] * 10.0f * this.getPower());
        }
    }

    public double getDistanceSqXZToEntity(Entity entity) {
        double d0 = this.m_20185_() - entity.m_20185_();
        double d2 = this.m_20189_() - entity.m_20189_();
        return d0 * d0 + d2 * d2;
    }

    private HitResult getHitResult() {
        Vec3 startPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 endPos = new Vec3(this.m_20185_(), (double)this.m_9236_().m_141937_(), this.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
    }
}

