/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.projectile;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.entity.ten_shadows.ToadEntity;

public class ToadTongueProjectile
extends JujutsuProjectile {
    public static final float SPEED = 2.0f;
    private static final int DURATION = 40;
    private int range;
    private UUID target;
    private boolean grabbed;
    private Vec3 pos;

    public ToadTongueProjectile(EntityType<? extends Projectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
    }

    public ToadTongueProjectile(LivingEntity owner, int range, UUID target) {
        this((EntityType<? extends Projectile>)((EntityType)JJKEntities.TOAD_TONGUE.get()), owner.m_9236_());
        this.m_5602_((Entity)owner);
        Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(this.m_20206_() / 2.0f) - 0.1, owner.m_20189_());
        this.m_146884_(spawn);
        this.target = target;
        this.range = range;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("range", this.range);
        pCompound.m_128362_("target", this.target);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.range = pCompound.m_128451_("range");
        this.target = pCompound.m_128342_("target");
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        this.m_146870_();
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        if (!target.m_20148_().equals(this.target)) {
            return;
        }
        this.grabbed = true;
        this.pos = target.m_20182_();
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        Entity owner = this.m_19749_();
        if (owner instanceof ToadEntity) {
            ToadEntity toad = (ToadEntity)owner;
            toad.setCanShoot(true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (this.m_9236_().f_46443_ || owner == null) {
            return;
        }
        if (this.getTime() >= 40) {
            this.m_146870_();
            return;
        }
        if (this.grabbed) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.target);
            if (entity instanceof LivingEntity) {
                ToadEntity toad;
                LivingEntity living = (LivingEntity)entity;
                if (!(owner instanceof ToadEntity) || (toad = (ToadEntity)owner).m_5448_() != living || living.m_21224_() || living.m_213877_()) {
                    this.m_146870_();
                }
                living.m_6021_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
                this.m_6034_(living.m_20185_(), living.m_20186_() + (double)(living.m_20206_() / 2.0f), living.m_20189_());
            } else {
                this.m_146870_();
            }
            this.m_20256_(Vec3.f_82478_);
        } else if (this.m_20270_(owner) >= (float)this.range) {
            this.m_146870_();
        }
    }
}

