/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.sorcerer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.SukunaEntity;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HeianSukunaEntity
extends SukunaEntity {
    private static final EntityDataAccessor<Boolean> DATA_IDLE = SynchedEntityData.m_135353_(HeianSukunaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_BARRAGE = SynchedEntityData.m_135353_(HeianSukunaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation BARRAGE = RawAnimation.begin().thenLoop("attack.barrage");
    private static final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("misc.sit");

    public HeianSukunaEntity(EntityType<? extends PathfinderMob> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public HeianSukunaEntity(Level pLevel, int fingers) {
        super((EntityType<? extends PathfinderMob>)((EntityType)JJKEntities.HEIAN_SUKUNA.get()), pLevel);
        this.fingers = fingers;
    }

    public void setBarrage(int barrage) {
        this.f_19804_.m_135381_(DATA_BARRAGE, (Object)barrage);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return HeianSukunaEntity.m_21552_().m_22268_(Attributes.f_22279_, 0.33).m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22284_, 80.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IDLE, (Object)false);
        this.f_19804_.m_135372_(DATA_BARRAGE, (Object)0);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)JJKItems.HITEN_STAFF.get()));
        this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)JJKItems.KAMUTOKE_DAGGER.get()));
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        super.m_8024_();
        this.f_19804_.m_135381_(DATA_IDLE, (Object)(this.m_5448_() == null && this.m_20184_().m_82556_() < 9.01 ? 1 : 0));
        int barrage = (Integer)this.f_19804_.m_135370_(DATA_BARRAGE);
        if (barrage > 0) {
            this.f_19804_.m_135381_(DATA_BARRAGE, (Object)(--barrage));
        }
        if (this.f_19796_.m_188503_(100) == 0 && (target = this.m_5448_()) != null) {
            EntityHitResult hit;
            this.m_6672_(InteractionHand.OFF_HAND);
            HitResult hitResult = RotationUtil.getLookAtHit((Entity)this, 60.0);
            if (hitResult instanceof EntityHitResult && (hit = (EntityHitResult)hitResult).m_82443_() == target) {
                this.m_5810_();
            }
        }
    }

    private PlayState walkRunSitPredicate(AnimationState<HeianSukunaEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        if (((Boolean)this.f_19804_.m_135370_(DATA_IDLE)).booleanValue()) {
            return animationState.setAndContinue(SIT);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<HeianSukunaEntity> animationState) {
        if ((Integer)this.f_19804_.m_135370_(DATA_BARRAGE) > 0) {
            return animationState.setAndContinue(BARRAGE);
        }
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Sit", this::walkRunSitPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @Override
    public List<Ability> getUnlocked() {
        return List.of((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get(), (Ability)JJKAbilities.MALEVOLENT_SHRINE.get(), (Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get(), (Ability)JJKAbilities.RCT1.get(), (Ability)JJKAbilities.RCT2.get(), (Ability)JJKAbilities.RCT3.get(), (Ability)JJKAbilities.DASH.get());
    }

    @Override
    @NotNull
    public List<Trait> getTraits() {
        ArrayList<Trait> traits = new ArrayList<Trait>(super.getTraits());
        traits.add(Trait.PERFECT_BODY);
        return traits;
    }
}

