/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.sorcerer;

import java.util.Collection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.AbsorbedCurse;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.item.JJKItems;

public class SuguruGetoEntity
extends SorcererEntity {
    public SuguruGetoEntity(EntityType<? extends PathfinderMob> pType, Level pLevel) {
        super(pType, pLevel);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.SPECIAL_GRADE.getRequiredExperience();
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return CursedTechnique.CURSE_MANIPULATION;
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SORCERER;
    }

    @Nullable
    private AbsorbedCurse createCurse(EntityType<?> type) {
        Entity entity = type.m_20615_(this.m_9236_());
        if (!(entity instanceof CursedSpirit)) {
            return null;
        }
        CursedSpirit curse = (CursedSpirit)entity;
        ISorcererData cap = (ISorcererData)curse.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return new AbsorbedCurse(type.m_20676_(), type, cap.serializeNBT());
    }

    private void tryAddCurse(ISorcererData data, EntityType<?> type) {
        AbsorbedCurse curse = this.createCurse(type);
        if (curse == null) {
            return;
        }
        data.addCurse(curse);
    }

    @Override
    public void init(ISorcererData data) {
        super.init(data);
        Collection registry = JJKEntities.ENTITIES.getEntries();
        for (RegistryObject entry : registry) {
            CursedSpirit curse;
            Entity entity;
            EntityType type = (EntityType)entry.get();
            if (type == JJKEntities.ABSORBED_PLAYER.get() || !((entity = type.m_20615_(this.m_9236_())) instanceof CursedSpirit) || (curse = (CursedSpirit)entity).getGrade().ordinal() >= SorcererGrade.SPECIAL_GRADE.ordinal()) continue;
            for (int i = 0; i < SorcererGrade.values().length - curse.getGrade().ordinal(); ++i) {
                this.tryAddCurse(data, type);
            }
        }
        this.tryAddCurse(data, (EntityType)JJKEntities.KUCHISAKE_ONNA.get());
        this.tryAddCurse(data, (EntityType)JJKEntities.DINO_CURSE.get());
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)JJKItems.PLAYFUL_CLOUD.get()));
    }
}

