/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.sorcerer;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.AbilityHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.JJKEntityDataSerializers;
import radon.jujutsu_kaisen.entity.sorcerer.HeianSukunaEntity;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.EntityUtil;

public class SukunaEntity
extends SorcererEntity {
    private static final EntityDataAccessor<String> DATA_ENTITY = SynchedEntityData.m_135353_(SukunaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<CompoundTag>> DATA_PLAYER = SynchedEntityData.m_135353_(SukunaEntity.class, (EntityDataSerializer)((EntityDataSerializer)JJKEntityDataSerializers.OPTIONAL_COMPOUND_TAG.get()));
    private static final int TAMING_CHANCE = 80;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;
    protected int fingers;
    private boolean vessel;
    @Nullable
    private GameType original;

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.m_21552_().m_22268_(Attributes.f_22279_, 0.33).m_22266_(Attributes.f_22281_).m_22268_(Attributes.f_22277_, 256.0).m_22268_(Attributes.f_22284_, 60.0);
    }

    public SukunaEntity(EntityType<? extends PathfinderMob> pType, Level pLevel) {
        super(pType, pLevel);
        Arrays.fill(this.f_21348_, 0.0f);
        Arrays.fill(this.f_21347_, 0.0f);
    }

    public SukunaEntity(LivingEntity owner, int fingers, boolean vessel) {
        this((EntityType<? extends PathfinderMob>)((EntityType)JJKEntities.SUKUNA.get()), owner.m_9236_());
        this.setOwner(owner);
        this.fingers = fingers;
        this.vessel = vessel;
        this.f_19804_.m_135381_(DATA_ENTITY, (Object)EntityType.m_20613_((EntityType)owner.m_6095_()).toString());
        if (owner instanceof Player) {
            Player player = (Player)owner;
            this.f_19804_.m_135381_(DATA_PLAYER, Optional.of(NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)player.m_36316_())));
        }
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean targetsSorcerers() {
        return true;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_5448_() != null) {
            return;
        }
        ISorcererData cap = (ISorcererData)this.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap == null) {
            return;
        }
        for (Entity entity : cap.getSummons()) {
            if (!(entity instanceof TenShadowsSummon)) continue;
            return;
        }
        if (this.f_19796_.m_188503_(80) == 0) {
            for (Ability ability : CursedTechnique.TEN_SHADOWS.getAbilities()) {
                Summon summon;
                if (!(ability instanceof Summon) || (summon = (Summon)ability).isTamed((LivingEntity)this)) continue;
                AbilityHandler.trigger((LivingEntity)this, ability);
                TenShadowsSummon shadow = cap.getSummonByClass(TenShadowsSummon.class);
                this.m_6710_((LivingEntity)shadow);
                return;
            }
            Summon mahoraga = (Summon)JJKAbilities.MAHORAGA.get();
            if (!mahoraga.isTamed((LivingEntity)this)) {
                AbilityHandler.trigger((LivingEntity)this, mahoraga);
                TenShadowsSummon shadow = cap.getSummonByClass(TenShadowsSummon.class);
                this.m_6710_((LivingEntity)shadow);
                return;
            }
        }
    }

    public EntityType<?> getEntity() {
        return (EntityType)EntityType.m_20632_((String)((String)this.f_19804_.m_135370_(DATA_ENTITY))).orElseThrow();
    }

    public EntityType<?> getKey() {
        return (EntityType)EntityType.m_20632_((String)((String)this.f_19804_.m_135370_(DATA_ENTITY))).orElseThrow();
    }

    public GameProfile getPlayer() {
        return NbtUtils.m_129228_((CompoundTag)((CompoundTag)((Optional)this.f_19804_.m_135370_(DATA_PLAYER)).orElseThrow()));
    }

    public GameType getOriginal(ServerPlayer player) {
        return this.original == null ? player.f_8924_.m_130008_() : this.original;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ENTITY, (Object)"");
        this.f_19804_.m_135372_(DATA_PLAYER, Optional.empty());
    }

    public boolean m_7306_(@NotNull Entity pEntity) {
        return this == pEntity || pEntity == this.getOwner();
    }

    public void m_8119_() {
        LivingEntity owner = this.getOwner();
        if (!this.m_9236_().f_46443_ && this.vessel && this.getKey() == EntityType.f_20532_ && (owner == null || owner.m_213877_() || !owner.m_6084_())) {
            this.m_146870_();
        } else {
            super.m_8119_();
            if (this.m_9236_().f_46443_ || this.m_213877_()) {
                return;
            }
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                if (this.original == null) {
                    this.original = player.f_8941_.m_9290_();
                }
                player.m_143403_(GameType.SPECTATOR);
                player.m_9213_((Entity)this);
            } else if (owner != null) {
                owner.m_146870_();
            }
        }
    }

    @Override
    public boolean m_21532_() {
        return true;
    }

    @Override
    public float getExperience() {
        float min = SorcererGrade.SPECIAL_GRADE.getRequiredExperience();
        float max = SorcererGrade.SPECIAL_GRADE.getRequiredExperience() * 4.0f;
        return min + (float)this.fingers * ((max - min) / 20.0f);
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return CursedTechnique.DISMANTLE_AND_CLEAVE;
    }

    @Override
    public List<Ability> getUnlocked() {
        return List.of((Ability)JJKAbilities.SIMPLE_DOMAIN.get(), (Ability)JJKAbilities.MALEVOLENT_SHRINE.get(), (Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get(), (Ability)JJKAbilities.RCT1.get(), (Ability)JJKAbilities.RCT2.get(), (Ability)JJKAbilities.RCT3.get(), (Ability)JJKAbilities.QUICKDASH.get());
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.SORCERER;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
        pCompound.m_128405_("fingers", this.fingers);
        pCompound.m_128379_("vessel", this.vessel);
        if (this.original != null) {
            pCompound.m_128405_("original", this.original.ordinal());
        }
        pCompound.m_128359_("entity", (String)this.f_19804_.m_135370_(DATA_ENTITY));
        ((Optional)this.f_19804_.m_135370_(DATA_PLAYER)).ifPresent(player -> pCompound.m_128365_("player", (Tag)player));
    }

    @Override
    public void init(ISorcererData data) {
        super.init(data);
        data.setAdditionalEnergy(this.getMaxEnergy() * 4.0f * (float)(this.fingers / 20));
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
        this.fingers = pCompound.m_128451_("fingers");
        this.vessel = pCompound.m_128471_("vessel");
        if (pCompound.m_128441_("original")) {
            this.original = GameType.values()[pCompound.m_128451_("original")];
        }
        this.f_19804_.m_135381_(DATA_ENTITY, (Object)pCompound.m_128461_("entity"));
        if (pCompound.m_128441_("player")) {
            this.f_19804_.m_135381_(DATA_PLAYER, Optional.of(pCompound.m_128469_("player")));
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            ISorcererData sorcererSrc = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ITenShadowsData tenShadowsSrc = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData sorcererDst = (ISorcererData)this.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ITenShadowsData tenShadowsDst = (ITenShadowsData)this.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            sorcererDst.setTraits(sorcererSrc.getTraits());
            sorcererDst.setAdditional(sorcererSrc.getTechnique());
            tenShadowsDst.setTamed(tenShadowsSrc.getTamed());
            tenShadowsDst.setDead(tenShadowsSrc.getDead());
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                player.m_143403_(this.original == null ? player.f_8924_.m_130008_() : this.original);
            }
            ITenShadowsData src = (ITenShadowsData)this.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            ITenShadowsData dst = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            dst.setTamed(src.getTamed());
            dst.setDead(src.getDead());
        }
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            owner.m_6074_();
        }
        if (!(this instanceof HeianSukunaEntity) && !this.vessel) {
            EntityUtil.convertTo((LivingEntity)this, (LivingEntity)new HeianSukunaEntity(this.m_9236_(), this.fingers), true, false);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

