/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ExplosionHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.DivineDogBlackEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.ToadEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MahoragaEntity
extends TenShadowsSummon {
    public static EntityDataAccessor<Integer> DATA_SLASH = SynchedEntityData.m_135353_(MahoragaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static EntityDataAccessor<Boolean> DATA_BATTLE = SynchedEntityData.m_135353_(MahoragaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation IDLE_BATTLE = RawAnimation.begin().thenLoop("misc.idle_battle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation SLASH = RawAnimation.begin().thenPlay("attack.slash");
    private static final double SLASH_LAUNCH = 30.0;
    private static final float SLASH_EXPLOSION = 5.0f;
    private static final float SLASH_DAMAGE = 15.0f;
    private static final int SLASH_DURATION = 20;
    private static final int RITUAL_DURATION = 60;
    private boolean healing;

    public MahoragaEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public MahoragaEntity(LivingEntity owner, boolean tame) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.MAHORAGA.get()), owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (!this.m_21824_() && this.getTime() <= 60) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_21525_() {
        return !this.m_21824_() && this.getTime() <= 60 || super.m_21525_();
    }

    public double m_6048_() {
        return (double)this.m_20206_() - 0.35;
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return true;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    public float getStepHeight() {
        return 4.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22276_, 48.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 40.0);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SLASH, (Object)0);
        this.f_19804_.m_135372_(DATA_BATTLE, (Object)false);
    }

    private PlayState walkRunIdlePredicate(AnimationState<MahoragaEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return animationState.setAndContinue((Boolean)this.f_19804_.m_135370_(DATA_BATTLE) != false ? IDLE_BATTLE : IDLE);
    }

    private PlayState swingPredicate(AnimationState<MahoragaEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState slashPredicate(AnimationState<MahoragaEntity> animationState) {
        int slash = (Integer)this.f_19804_.m_135370_(DATA_SLASH);
        if (slash > 0) {
            return animationState.setAndContinue(SLASH);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", this::walkRunIdlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Slash", this::slashPredicate)});
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean result = super.m_7327_(pEntity);
        if (result) {
            if (!(pEntity instanceof LivingEntity)) {
                return true;
            }
            LivingEntity living = (LivingEntity)pEntity;
            if (!pEntity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return true;
            }
            ISorcererData cap = (ISorcererData)pEntity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.getType() == JujutsuType.CURSE) {
                pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), living.m_21233_() * 0.5f);
            }
        }
        return result;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        this.f_19804_.m_135381_(DATA_BATTLE, (Object)(target != null ? 1 : 0));
        int slash = (Integer)this.f_19804_.m_135370_(DATA_SLASH);
        if (slash > 0) {
            this.f_19804_.m_135381_(DATA_SLASH, (Object)(--slash));
        } else if (target != null) {
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), (double)0.8f);
            if (this.m_20096_() && (double)this.m_20270_((Entity)target) < 5.0) {
                this.f_19804_.m_135381_(DATA_SLASH, (Object)20);
                target.m_20256_(RotationUtil.getTargetAdjustedLookAngle((Entity)this).m_82490_(30.0));
                target.f_19864_ = true;
                Vec3 explosionPos = new Vec3(this.m_20185_(), this.m_20188_() - 0.2, this.m_20189_()).m_82549_(RotationUtil.getTargetAdjustedLookAngle((Entity)this));
                ExplosionHandler.spawn((ResourceKey<Level>)this.m_9236_().m_46472_(), explosionPos, 5.0f, 20, 3.75f, (LivingEntity)this, JJKDamageSources.indirectJujutsuAttack((Entity)this, (LivingEntity)this, (Ability)JJKAbilities.DISMANTLE.get()), false);
            }
        }
    }

    private void setRitualOffset(Mob entity, int index, double padding) {
        entity.m_21557_(true);
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        double distance = entity.m_20205_() * 2.0f;
        Vec3 look = RotationUtil.calculateViewVector(0.0f, entity.m_146908_());
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 side = look.m_82537_(up);
        Vec3 offset = side.m_82490_(distance * (double)(index < 3 ? 1 : -1)).m_82549_(look.m_82490_(padding + (double)(index % 3) * 3.0));
        entity.m_6034_(x + offset.f_82479_, y, z + offset.f_82481_);
        float yRot = entity.m_146908_();
        yRot = index < 3 ? (yRot -= 90.0f) : (yRot += 90.0f);
        entity.m_146922_(yRot);
        entity.f_20886_ = entity.f_20885_ = entity.m_146908_();
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_21824_()) {
            LivingEntity owner = this.m_269323_();
            if (owner != null) {
                if (!owner.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
                    return;
                }
                ITenShadowsData src = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
                ITenShadowsData dst = (ITenShadowsData)this.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
                dst.addAdapted(src.getAdapted());
                dst.addAdapting(src.getAdapting());
            }
        } else {
            int i;
            this.m_5496_((SoundEvent)JJKSounds.WOLF_HOWLING.get(), 3.0f, 1.0f);
            for (i = 0; i < 6; ++i) {
                DivineDogBlackEntity dog = new DivineDogBlackEntity((LivingEntity)this, true);
                dog.setRitual(60);
                this.setRitualOffset((Mob)dog, i, 1.5);
                this.m_9236_().m_7967_((Entity)dog);
            }
            for (i = 0; i < 6; ++i) {
                ToadEntity toad = new ToadEntity((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.TOAD.get()), (LivingEntity)this, false, true);
                toad.setRitual(60);
                this.setRitualOffset((Mob)toad, i, 0.0);
                this.m_9236_().m_7967_((Entity)toad);
            }
        }
    }

    @Override
    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.m_21824_()) {
            return;
        }
        LivingEntity owner = this.m_269323_();
        if (owner == null) {
            return;
        }
        if (!owner.getCapability(TenShadowsDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ITenShadowsData src = (ITenShadowsData)this.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        ITenShadowsData dst = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        dst.addAdapted(src.getAdapted());
        dst.addAdapting(src.getAdapting());
    }

    public void onAdaptation() {
        this.healing = this.m_21223_() < this.m_21233_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() != this.m_21233_()) {
            this.m_5634_(0.05f);
        }
    }

    @Override
    public float getExperience() {
        return Math.max(SorcererGrade.SPECIAL_GRADE.getRequiredExperience(), super.getExperience());
    }

    @Override
    public float getMaxEnergy() {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    @NotNull
    public List<Ability> getCustom() {
        return List.of((Ability)JJKAbilities.WHEEL.get());
    }

    @Override
    public Summon<?> getAbility() {
        return (Summon)JJKAbilities.MAHORAGA.get();
    }
}

