/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.ten_shadows;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.projectile.ToadTongueProjectile;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ToadEntity
extends TenShadowsSummon {
    private static final EntityDataAccessor<Integer> DATA_RITUAL = SynchedEntityData.m_135353_(ToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_CAN_SHOOT = SynchedEntityData.m_135353_(ToadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private static final RawAnimation TONGUE = RawAnimation.begin().thenPlayAndHold("attack.tongue");
    private static final RawAnimation HOWL = RawAnimation.begin().thenPlayAndHold("misc.howl");
    private static final int RANGE = 60;
    private static final int SHOOT_INTERVAL = 120;

    public ToadEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public ToadEntity(EntityType<? extends TamableAnimal> type, LivingEntity owner, boolean tame, boolean ritual) {
        this(type, owner.m_9236_());
        this.m_7105_(tame);
        this.setOwner(owner);
        Vec3 direction = RotationUtil.calculateViewVector(0.0f, owner.m_146908_());
        Vec3 pos = ritual ? owner.m_20182_() : owner.m_20182_().m_82546_(direction.m_82542_((double)this.m_20205_(), 0.0, (double)this.m_20205_()));
        this.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, owner.m_146908_(), owner.m_146909_());
        this.f_20886_ = this.f_20885_ = this.m_146908_();
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public boolean m_20147_() {
        return (Integer)this.f_19804_.m_135370_(DATA_RITUAL) > 0 || super.m_20147_();
    }

    @Override
    protected boolean isCustom() {
        return true;
    }

    @Override
    protected boolean canFly() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return true;
    }

    protected void m_8099_() {
        int goal = 1;
        int target = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 25.0f, 10.0f, this.canFly()));
            this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        } else {
            this.f_21346_.m_25352_(target, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, entity -> this.participants.contains(entity.m_20148_())));
        }
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean hasWings() {
        return false;
    }

    public void setRitual(int duration) {
        this.f_19804_.m_135381_(DATA_RITUAL, (Object)duration);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RITUAL, (Object)0);
        this.f_19804_.m_135372_(DATA_CAN_SHOOT, (Object)true);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ritual", ((Integer)this.f_19804_.m_135370_(DATA_RITUAL)).intValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_RITUAL, (Object)pCompound.m_128451_("ritual"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 1.0);
    }

    private PlayState walkPredicate(AnimationState<ToadEntity> animationState) {
        if (animationState.isMoving()) {
            return animationState.setAndContinue(WALK);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<ToadEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    private PlayState tonguePredicate(AnimationState<ToadEntity> animationState) {
        if (!this.canShoot()) {
            return animationState.setAndContinue(TONGUE);
        }
        return PlayState.STOP;
    }

    private PlayState howlPredicate(AnimationState<ToadEntity> animationState) {
        if ((Integer)this.f_19804_.m_135370_(DATA_RITUAL) > 0) {
            return animationState.setAndContinue(HOWL);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk", this::walkPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Tongue", this::tonguePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Howl", this::howlPredicate)});
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    @Override
    public Summon<?> getAbility() {
        return this.hasWings() ? (Summon)JJKAbilities.TOAD_FUSION.get() : (Summon)JJKAbilities.TOAD.get();
    }

    public boolean canShoot() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CAN_SHOOT);
    }

    public void setCanShoot(boolean canShoot) {
        this.f_19804_.m_135381_(DATA_CAN_SHOOT, (Object)canShoot);
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        if (!this.canShoot()) {
            this.f_21342_.m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.m_6113_());
        }
        LivingEntity owner = this.m_269323_();
        if (this.m_21824_() && owner != null && this.hasWings()) {
            for (AbstractArrow arrow : this.m_9236_().m_45976_(AbstractArrow.class, owner.m_20191_().m_82400_(1.0))) {
                if (arrow.m_19749_() == this.m_269323_()) continue;
                this.shoot((Entity)arrow);
                arrow.m_146870_();
            }
        }
        if ((target = this.m_5448_()) != null && target.m_6084_() && !target.m_213877_()) {
            this.f_21365_.m_24960_((Entity)target, 30.0f, 30.0f);
            this.f_21342_.m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.5);
            if (this.m_142582_((Entity)target) && this.m_20270_((Entity)target) <= 60.0f && this.getTime() % 120 == 0) {
                this.shoot((Entity)target);
            }
        }
    }

    @Override
    public void m_8119_() {
        int ritual = (Integer)this.f_19804_.m_135370_(DATA_RITUAL);
        if (ritual > 0) {
            this.f_19804_.m_135381_(DATA_RITUAL, (Object)(--ritual));
            if (ritual == 0) {
                this.m_146870_();
            }
        } else {
            super.m_8119_();
        }
    }

    private void shoot(Entity target) {
        if (!this.canShoot()) {
            return;
        }
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0));
        Vec3 start = this.m_146892_();
        Vec3 end = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        double d0 = end.f_82479_ - start.f_82479_;
        double d1 = end.f_82480_ - start.f_82480_;
        double d2 = end.f_82481_ - start.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float yaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        float pitch = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        Vec3 speed = this.m_20171_(pitch, yaw).m_82490_(2.0 * (this.hasWings() ? 5.0 : 1.0));
        ToadTongueProjectile tongue = new ToadTongueProjectile((LivingEntity)this, 60, target.m_20148_());
        tongue.m_20256_(speed);
        this.m_9236_().m_7967_((Entity)tongue);
        this.f_19804_.m_135381_(DATA_CAN_SHOOT, (Object)false);
    }
}

