/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.AbilityStopEvent;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.block.VeilBlock;
import radon.jujutsu_kaisen.block.VeilRodBlock;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.JJKPartEntity;
import radon.jujutsu_kaisen.entity.projectile.ThrownChainProjectile;
import radon.jujutsu_kaisen.entity.sorcerer.HeianSukunaEntity;
import radon.jujutsu_kaisen.entity.sorcerer.SukunaEntity;
import radon.jujutsu_kaisen.item.CursedEnergyFleshItem;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.CuriosUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.PlayerUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class JJKEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class JJKEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onExplosion(ExplosionEvent.Detonate event) {
            Explosion explosion = event.getExplosion();
            LivingEntity instigator = explosion.m_252906_();
            Iterator iter = explosion.m_46081_().iterator();
            while (iter.hasNext()) {
                BlockPos pos = (BlockPos)iter.next();
                Vec3 center = pos.m_252807_();
                if (VeilHandler.canDestroy(instigator, event.getLevel(), center.f_82479_, center.f_82480_, center.f_82481_)) continue;
                iter.remove();
            }
        }

        @SubscribeEvent
        public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
            LivingEntity entity = event.getEntity();
            Vec3 center = event.getPos().m_252807_();
            if (!VeilHandler.canDestroy(event.getEntity(), entity.m_9236_(), center.f_82479_, center.f_82480_, center.f_82481_)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            BlockPos pos = event.getPos();
            Level level = (Level)event.getLevel();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof VeilRodBlock || block instanceof VeilBlock) {
                return;
            }
            Vec3 center = pos.m_252807_();
            if (!VeilHandler.canDestroy((LivingEntity)player, level, center.f_82479_, center.f_82480_, center.f_82481_)) {
                event.setCanceled(true);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 3);
                }
            }
        }

        @SubscribeEvent
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            BlockPos pos;
            Entity entity = event.getEntity();
            ServerLevel level = (ServerLevel)event.getLevel();
            if (!VeilHandler.getDomains(level, pos = event.getPos()).isEmpty()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onSleepFinished(SleepFinishedTimeEvent event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (!(levelAccessor instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)levelAccessor;
            for (ServerPlayer player : level.m_6907_()) {
                if (!player.m_36317_() || !player.getCapability(SorcererDataHandler.INSTANCE).isPresent()) continue;
                ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                cap.setEnergy(cap.getMaxEnergy());
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }

        @SubscribeEvent
        public static void onAttackEntity(AttackEntityEvent event) {
            if (event.getTarget() instanceof JJKPartEntity) {
                Entity parent = ((JJKPartEntity)event.getTarget()).getParent();
                if (parent != null) {
                    event.getEntity().m_5706_(parent);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            for (SukunaEntity sukuna : player2.m_9236_().m_45976_(SukunaEntity.class, AABB.m_165882_((Vec3)player2.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (sukuna.getOwner() != player2) continue;
                player2.m_143403_(sukuna.getOriginal(player2));
            }
        }

        @SubscribeEvent
        public static void onPlayerClone(PlayerEvent.Clone event) {
            Player original = event.getOriginal();
            Player player = event.getEntity();
            original.reviveCaps();
            ISorcererData oldCap = (ISorcererData)original.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData newCap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            newCap.deserializeNBT(oldCap.serializeNBT());
            if (event.isWasDeath()) {
                newCap.setEnergy(newCap.getMaxEnergy());
                newCap.resetCooldowns();
                newCap.resetBurnout();
                newCap.resetDisable();
                newCap.clearToggled();
                newCap.setCurrentCopied(null);
                newCap.resetCopy();
                newCap.resetBlackFlash();
                newCap.resetExtraEnergy();
                newCap.resetSpeedStacks();
                newCap.resetDash();
                if (!player.m_9236_().f_46443_) {
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(newCap.serializeNBT()), (ServerPlayer)player);
                }
            }
            original.invalidateCaps();
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            LivingEntity victim = event.getEntity();
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (victim.m_21223_() - event.getAmount() <= 0.0f) {
                return;
            }
            cap.attack(event.getSource(), victim);
            if (victim.m_21224_()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity owner = event.getEntity();
            if (owner.m_21224_()) {
                return;
            }
            if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.tick(owner);
            if (cap.hasTrait(Trait.SIX_EYES) && !owner.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)JJKItems.BLINDFOLD.get()) || cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, false, false, false));
            }
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 2, 1, false, false, false));
            }
            owner.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 2, 2, false, false, false));
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_36324_().m_38705_(20);
            }
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            LivingEntity victim = event.getEntity();
            event.getEntity().getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                    event.setDistance(event.getDistance() * 0.1f);
                } else {
                    event.setDistance(event.getDistance() * 0.33f);
                }
            });
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (((Boolean)ConfigHolder.SERVER.realisticCurses.get()).booleanValue()) {
                ItemStack itemStack;
                Entity entity2 = source.m_7640_();
                if (entity2 instanceof ThrownChainProjectile) {
                    ThrownChainProjectile chain = (ThrownChainProjectile)entity2;
                    itemStack = chain.getStack();
                } else {
                    itemStack = attacker.m_21120_(InteractionHand.MAIN_HAND);
                }
                ItemStack stack = itemStack;
                ArrayList<Item> stacks = new ArrayList<Item>();
                stacks.add(stack.m_41720_());
                stacks.addAll(CuriosUtil.findSlots(attacker, attacker.m_5737_() == HumanoidArm.RIGHT ? "right_hand" : "left_hand").stream().map(ItemStack::m_41720_).toList());
                if (JJKAbilities.getType(victim) == JujutsuType.CURSE) {
                    boolean cursed = false;
                    if (event.getSource() instanceof JJKDamageSources.JujutsuDamageSource) {
                        cursed = true;
                    } else if (HelperMethods.isMelee(source) && stacks.stream().anyMatch(item -> item instanceof CursedToolItem)) {
                        cursed = true;
                    } else if (attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                        ISorcererData cap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                        boolean bl = cursed = cap.getEnergy() > 0.0f;
                    }
                    if (!cursed) {
                        event.setCanceled(true);
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingHurt(LivingHurtEvent event) {
            Entity attackerEntity;
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            DamageSource source = event.getSource();
            if (source instanceof JJKDamageSources.JujutsuDamageSource) {
                Entity entity = source.m_7639_();
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity sourceUser = (LivingEntity)entity;
                ISorcererData capSelf2 = (ISorcererData)sourceUser.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (source.m_7639_() == victim && !capSelf2.hasSelfHit()) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
            }
            if ((attackerEntity = source.m_7639_()) instanceof Projectile) {
                Projectile projectile = (Projectile)attackerEntity;
                attackerEntity = projectile.m_19749_();
            }
            if (!(attackerEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)attackerEntity;
            if (JJKAbilities.hasTrait(attacker, Trait.PERFECT_BODY)) {
                attacker.getCapability(SorcererDataHandler.INSTANCE).ifPresent(capSelf -> {
                    if (HelperMethods.isMelee(source) && !capSelf.hasToggled((Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get())) {
                        event.setAmount(event.getAmount() * 1.5f);
                    }
                });
            }
            if (source.m_269533_(DamageTypeTags.f_268490_)) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float armor = SorcererUtil.getDefense(cap.getExperience());
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                armor = SorcererUtil.getDefenseHR(cap.getExperience());
            }
            float blocked = event.getAmount() / armor;
            event.setAmount(blocked);
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            switch (victimCap.getType()) {
                case SORCERER: {
                    if (HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.sorcererFleshRarity.get()).intValue()) != 0) break;
                    ItemStack stack = new ItemStack((ItemLike)JJKItems.SORCERER_FLESH.get());
                    CursedEnergyFleshItem.setGrade(stack, SorcererUtil.getGrade(victimCap.getExperience()));
                    victim.m_19983_(stack);
                    break;
                }
                case CURSE: {
                    if (HelperMethods.RANDOM.m_188503_(((Integer)ConfigHolder.SERVER.curseFleshRarity.get()).intValue()) != 0) break;
                    ItemStack stack = new ItemStack((ItemLike)JJKItems.CURSE_FLESH.get());
                    CursedEnergyFleshItem.setGrade(stack, SorcererUtil.getGrade(victimCap.getExperience()));
                    victim.m_19983_(stack);
                }
            }
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                if (victim instanceof HeianSukunaEntity && victimCap.getFingers() == 20) {
                    PlayerUtil.giveAdvancement(player, "the_strongest_of_all_time");
                }
            }
        }

        @SubscribeEvent
        public static void onAbilityStop(AbilityStopEvent event) {
            Ability ability = event.getAbility();
            CursedTechnique technique = JJKAbilities.getTechnique(ability);
            LivingEntity owner = event.getEntity();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (technique != null && cap.getAbsorbed().contains((Object)technique)) {
                cap.unabsorb(technique);
            }
        }

        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Pre event) {
            Ability ability = event.getAbility();
            CursedTechnique technique = JJKAbilities.getTechnique(ability);
            LivingEntity owner = event.getEntity();
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (ability.getActivationType(owner) == Ability.ActivationType.INSTANT && technique != null && cap.getAbsorbed().contains((Object)technique)) {
                cap.unabsorb(technique);
            }
        }
    }
}

