/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class RCTEventHandler {

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class RCTEventHandlerForgeEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            TamableAnimal tamable;
            DamageSource source = event.getSource();
            if (!(source.m_7639_() instanceof LivingEntity)) {
                return;
            }
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (victim.m_21223_() - event.getAmount() > 0.0f) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.isUnlocked((Ability)JJKAbilities.RCT1.get())) {
                return;
            }
            if (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21824_()) {
                return;
            }
            if (cap.hasTrait(Trait.HEAVENLY_RESTRICTION)) {
                return;
            }
            if (cap.getType() != JujutsuType.SORCERER) {
                return;
            }
            if (SorcererUtil.getGrade(cap.getExperience()).ordinal() < SorcererGrade.SEMI_GRADE_2.ordinal()) {
                return;
            }
            int chance = (Integer)ConfigHolder.SERVER.reverseCursedTechniqueChance.get();
            if (cap.hasTrait(Trait.RCT_OUTPUT)) {
                chance = 2;
            }
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = victim.m_21120_(hand);
                if (!stack.m_150930_(Items.f_42747_)) continue;
                chance /= 2;
            }
            if (HelperMethods.RANDOM.m_188503_(chance) != 0) {
                return;
            }
            victim.m_21153_(victim.m_21233_() / 2.0f);
            cap.unlock((Ability)JJKAbilities.RCT1.get());
            if (victim instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)victim;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
            event.setCanceled(true);
        }
    }
}

