/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.item.cursed_tool;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.client.render.item.DragonBoneRenderer;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.item.base.CursedToolItem;
import radon.jujutsu_kaisen.util.RotationUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonBoneItem
extends CursedToolItem
implements GeoItem {
    private static final float MAX_ENERGY = 100.0f;
    private static final double RANGE = 16.0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DragonBoneItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    @Override
    public SorcererGrade getGrade() {
        return SorcererGrade.SPECIAL_GRADE;
    }

    public static float getEnergy(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128457_("energy");
    }

    public static void addEnergy(ItemStack stack, float energy) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("energy")) {
            energy += nbt.m_128457_("energy");
        }
        nbt.m_128350_("energy", Math.min(100.0f, energy));
    }

    public static void resetEnergy(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128350_("energy", 0.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        LivingEntity entity;
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        float charge = DragonBoneItem.getEnergy(stack) / 100.0f;
        if (charge > 0.5f && (entity = RotationUtil.getExpandedLookAt((Entity)pPlayer, 16.0)) != null) {
            pPlayer.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            Vec3 pos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            Level level = pPlayer.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
            }
            entity.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
            ISorcererData cap = (ISorcererData)pPlayer.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack((LivingEntity)pPlayer, null), this.m_43299_() * cap.getRealPower() * charge * 4.25f);
            pPlayer.m_6674_(InteractionHand.MAIN_HAND);
            DragonBoneItem.resetEnergy(stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237110_((String)String.format("%s.energy", this.m_5524_()), (Object[])new Object[]{Float.valueOf(DragonBoneItem.getEnergy(pStack) / 100.0f * 100.0f)}));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DragonBoneRenderer renderer;

            public DragonBoneRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DragonBoneRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

