/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.util.HelperMethods;

public class AddChantC2SPacket {
    private final ResourceLocation key;
    private final String chant;

    public AddChantC2SPacket(ResourceLocation key, String chant) {
        this.key = key;
        this.chant = chant;
    }

    public AddChantC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130281_(), buf.m_130277_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.key);
        buf.m_130070_(this.chant);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            assert (sender != null);
            if (this.chant.length() > (Integer)ConfigHolder.SERVER.maximumChantLength.get()) {
                return;
            }
            Ability ability = JJKAbilities.getValue(this.key);
            if (ability == null || !ability.isScalable((LivingEntity)sender) || !ability.isTechnique()) {
                return;
            }
            ISorcererData cap = (ISorcererData)sender.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            String text = this.chant.toLowerCase();
            if (!text.isEmpty() && !text.isBlank()) {
                for (String chant : cap.getFirstChants(ability)) {
                    if (!((double)HelperMethods.strcmp(chant, text) < (Double)ConfigHolder.SERVER.chantSimilarityThreshold.get())) continue;
                    return;
                }
            }
            if (cap.getFirstChants(ability).size() == ((Integer)ConfigHolder.SERVER.maximumChantCount.get()).intValue() || text.isEmpty() || text.isBlank() || cap.hasChant(ability, text)) {
                return;
            }
            cap.addChant(ability, text);
        });
        ctx.setPacketHandled(true);
    }
}

