/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.util;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.block.entity.DomainBlockEntity;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;

public class HelperMethods {
    public static final RandomSource RANDOM = RandomSource.m_216337_();
    private static final String[] WORDS = new String[]{"Nah, I'd win.", "Stand proud.", "You can cook.", "Did you pray today?", "You're strong.", "Are you the strongest because?", "Owari da.", "I shall never forget you.", "With this treasure I summon...", "Have you ever trained?"};

    public static boolean isMelee(DamageSource source) {
        JJKDamageSources.JujutsuDamageSource jujutsu;
        return !source.m_269014_() && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(JJKDamageSources.SPLIT_SOUL_KATANA)) || source instanceof JJKDamageSources.JujutsuDamageSource && (jujutsu = (JJKDamageSources.JujutsuDamageSource)source).getAbility() != null && jujutsu.getAbility().isMelee();
    }

    private static BlockPos getTopNonCollidingPos(LevelReader level, EntityType<?> type, int x, int z) {
        BlockPos below;
        int i = level.m_6924_(SpawnPlacements.m_21765_(type), x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, i, z);
        if (level.m_6042_().f_63856_()) {
            do {
                pos.m_122173_(Direction.DOWN);
            } while (!level.m_8055_((BlockPos)pos).m_60795_());
            do {
                pos.m_122173_(Direction.DOWN);
            } while (level.m_8055_((BlockPos)pos).m_60795_() && pos.m_123342_() > level.m_141937_());
        }
        if (SpawnPlacements.m_21752_(type) == SpawnPlacements.Type.ON_GROUND && level.m_8055_(below = pos.m_7495_()).m_60647_((BlockGetter)level, below, PathComputationType.LAND)) {
            return below;
        }
        return pos.m_7949_();
    }

    public static BlockPos findSafePos(ServerLevel level, LivingEntity entity) {
        BlockPos.MutableBlockPos pos = entity.m_20183_().m_122032_();
        level.m_8904_().m_27056_((LevelReader)level, (BlockPos)pos, 16);
        double minX = level.m_6857_().m_61955_();
        double maxX = level.m_6857_().m_61957_();
        double minZ = level.m_6857_().m_61956_();
        double maxZ = level.m_6857_().m_61958_();
        EntityType type = entity.m_6095_();
        while (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)type), (LevelReader)level, (BlockPos)pos, (EntityType)type)) {
            pos.m_122169_(minX + RANDOM.m_188500_() * (maxX - minX), 0.0, minZ + RANDOM.m_188500_() * (maxZ - minZ));
            level.m_8904_().m_27056_((LevelReader)level, (BlockPos)pos, 16);
            pos.m_122190_((Vec3i)HelperMethods.getTopNonCollidingPos((LevelReader)level, type, pos.m_123341_(), pos.m_123343_()));
        }
        return pos.m_7949_();
    }

    public static int getRGB24(Vector3f rgb) {
        return FastColor.ARGB32.m_13660_((int)255, (int)Math.round(rgb.x * 255.0f), (int)Math.round(rgb.y * 255.0f), (int)Math.round(rgb.z * 255.0f));
    }

    public static boolean isDestroyable(BlockGetter getter, @Nullable LivingEntity source, BlockPos pos) {
        Level level;
        boolean destroyable;
        if (!((Boolean)ConfigHolder.SERVER.destruction.get()).booleanValue()) {
            return false;
        }
        if (source != null && !(source instanceof Player) && !source.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            return false;
        }
        if (source != null && !VeilHandler.canDestroy(source, source.m_9236_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            return false;
        }
        BlockState state = getter.m_8055_(pos);
        boolean bl = destroyable = !state.m_60795_() && state.m_60734_().m_155943_() > -1.0f;
        if (!destroyable && source != null && (level = source.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level = getter.m_7702_(pos);
            if (level instanceof DomainBlockEntity) {
                DomainExpansionEntity domain;
                Entity entity;
                DomainBlockEntity be = (DomainBlockEntity)level;
                UUID identifier = be.getIdentifier();
                destroyable = identifier == null || !((entity = level2.m_8791_(identifier)) instanceof DomainExpansionEntity) || !(domain = (DomainExpansionEntity)entity).isInsideBarrier(source.m_20183_());
            }
        }
        return destroyable;
    }

    public static Set<String> getRandomWordCombo(int count) {
        if (count > WORDS.length) {
            throw new IllegalArgumentException("Number of words requested exceeds the available word list.");
        }
        HashSet<String> combo = new HashSet<String>();
        while (combo.size() < count) {
            combo.add(WORDS[RANDOM.m_188503_(WORDS.length)]);
        }
        return combo;
    }

    public static <E> E getWeightedRandom(Map<E, Double> weights, RandomSource random) {
        E result = null;
        double bestValue = Double.MAX_VALUE;
        for (E element : weights.keySet()) {
            double value = -Math.log(random.m_188500_()) / weights.get(element);
            if (!(value < bestValue)) continue;
            bestValue = value;
            result = element;
        }
        return result;
    }

    public static int getLevenshteinDistance(String x, String y) {
        int m = x.length();
        int n = y.length();
        int[][] T = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            T[i][0] = i;
        }
        for (int j = 1; j <= n; ++j) {
            T[0][j] = j;
        }
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                T[i][j] = Integer.min(Integer.min(T[i - 1][j] + 1, T[i][j - 1] + 1), T[i - 1][j - 1] + cost);
            }
        }
        return T[m][n];
    }

    public static float strcmp(String x, String y) {
        float max = Float.max(x.length(), y.length());
        if (max > 0.0f) {
            return 1.0f - (max - (float)HelperMethods.getLevenshteinDistance(x, y)) / max;
        }
        return 0.0f;
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[RANDOM.m_188503_(((Enum[])clazz.getEnumConstants()).length)];
    }

    public static <T extends Enum<T>> T randomEnum(Class<T> clazz, Set<T> excluded) {
        EnumSet<T> available;
        if (!excluded.isEmpty() && !(available = EnumSet.complementOf(EnumSet.copyOf(excluded))).isEmpty()) {
            return (T)((Enum)available.toArray()[RANDOM.m_188503_(available.size())]);
        }
        return (T)((Enum[])clazz.getEnumConstants())[RANDOM.m_188503_(((Enum[])clazz.getEnumConstants()).length)];
    }

    public static int toRGB24(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

