/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Math;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.curse.base.PackCursedSpirit;
import radon.jujutsu_kaisen.entity.ten_shadows.base.TenShadowsSummon;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.SorcererUtil;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExperienceHandler {
    private static final Map<UUID, CopyOnWriteArraySet<BattleData>> battles = new HashMap<UUID, CopyOnWriteArraySet<BattleData>>();

    private static void addBattle(UUID ownerUUID, BattleData data) {
        if (!battles.containsKey(ownerUUID)) {
            battles.put(ownerUUID, new CopyOnWriteArraySet());
        }
        battles.get(ownerUUID).add(data);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        TamableAnimal tamable;
        LivingEntity victim = event.getEntity();
        if (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21824_()) {
            return;
        }
        if (victim instanceof TenShadowsSummon) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (!victim.m_6084_() || victim.m_213877_() || !attacker.m_6084_() || attacker.m_213877_()) {
                return;
            }
            if (attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                TamableAnimal tamable2;
                Iterator<Map.Entry<UUID, CopyOnWriteArraySet<BattleData>>> iter = battles.entrySet().iterator();
                boolean existing = false;
                while (iter.hasNext()) {
                    for (BattleData battle : iter.next().getValue()) {
                        if (battle.getTargetUUID() != victim.m_20148_()) continue;
                        battle.attack(attacker.m_20148_(), event.getAmount());
                        existing = true;
                    }
                }
                while (attacker instanceof TamableAnimal && (tamable2 = (TamableAnimal)attacker).m_21824_()) {
                    attacker = tamable2.m_269323_();
                    if (attacker != null) continue;
                    return;
                }
                if (!existing) {
                    BattleData battle = new BattleData(attacker.m_20148_(), victim.m_20148_());
                    ExperienceHandler.addBattle(attacker.m_20148_(), battle);
                    battle.attack(attacker.m_20148_(), event.getAmount());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity owner = event.getEntity();
        battles.remove(owner.m_20148_());
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getExperience() > 0.0f) {
            ServerPlayer player;
            float penalty = cap.getExperience() * ((Double)ConfigHolder.SERVER.deathPenalty.get()).floatValue();
            cap.setExperience(Math.max((float)0.0f, (float)(cap.getExperience() - penalty)));
            int points = (int)Math.floor((float)(penalty * 0.1f * ((Double)ConfigHolder.SERVER.pointPenalty.get()).floatValue()));
            if (points > 0) {
                cap.setPoints(Math.max((int)0, (int)(cap.getPoints() - points)));
                if ((double)((Double)ConfigHolder.SERVER.pointPenalty.get()).floatValue() != 0.0 && entity instanceof ServerPlayer) {
                    player = (ServerPlayer)entity;
                    player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.points_penalty", "jujutsu_kaisen"), (Object[])new Object[]{points}));
                    PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
                }
            }
            if ((double)((Double)ConfigHolder.SERVER.deathPenalty.get()).floatValue() != 0.0 && entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.experience_penalty", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(penalty)}));
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }
        Iterator<Map.Entry<UUID, CopyOnWriteArraySet<BattleData>>> battleIter = battles.entrySet().iterator();
        while (battleIter.hasNext()) {
            Set current = battleIter.next().getValue();
            ArrayList<BattleData> battlesToRemove = new ArrayList<BattleData>();
            for (BattleData battle : current) {
                if (!battle.getOwnerUUID().equals(entity.m_20148_()) && !battle.getTargetUUID().equals(entity.m_20148_())) continue;
                battle.end(level2);
                battlesToRemove.add(battle);
            }
            battlesToRemove.forEach(current::remove);
            if (!current.isEmpty()) continue;
            battleIter.remove();
        }
    }

    private static class BattleData {
        private final UUID ownerUUID;
        private final UUID targetUUID;
        private float totalDamageDealt;
        private float damageDealtByOwner;

        public BattleData(UUID ownerUUID, UUID targetUUID) {
            this.ownerUUID = ownerUUID;
            this.targetUUID = targetUUID;
        }

        public UUID getOwnerUUID() {
            return this.ownerUUID;
        }

        public UUID getTargetUUID() {
            return this.targetUUID;
        }

        private static float calculateStrength(LivingEntity entity) {
            float strength = entity.m_21233_() * 0.1f;
            float armor = entity.m_21230_();
            float toughness = (float)entity.m_21133_(Attributes.f_22285_);
            float f = 2.0f + toughness / 4.0f;
            float f1 = Mth.m_14036_((float)(armor - strength / f), (float)(armor * 0.2f), (float)20.0f);
            strength /= 1.0f - f1 / 25.0f;
            MobEffectInstance instance = entity.m_21124_(MobEffects.f_19606_);
            if (instance != null) {
                int resistance = instance.m_19564_();
                int i = (resistance + 1) * 5;
                int j = 25 - i;
                if (j == 0) {
                    return strength;
                }
                float x = 25.0f / (float)j;
                strength *= x;
            }
            strength += (float)entity.m_21133_(Attributes.f_22281_);
            strength += (float)entity.m_21133_(Attributes.f_22279_);
            if (entity instanceof PackCursedSpirit) {
                PackCursedSpirit pack = (PackCursedSpirit)entity;
                strength += (float)pack.getMinCount() + (float)(pack.getMaxCount() - pack.getMinCount()) / 2.0f;
            }
            if (entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                strength += cap.getExperience() * 0.1f;
                if (cap.getType() == JujutsuType.CURSE || cap.isUnlocked((Ability)JJKAbilities.RCT1.get())) {
                    strength *= 1.25f;
                }
            }
            return strength;
        }

        public void end(ServerLevel level) {
            ServerPlayer player;
            int points;
            Player targetplayer;
            LivingEntity owner;
            Entity entity;
            block15: {
                block14: {
                    entity = level.m_8791_(this.ownerUUID);
                    if (!(entity instanceof LivingEntity)) break block14;
                    owner = (LivingEntity)entity;
                    entity = level.m_8791_(this.targetUUID);
                    if (entity instanceof LivingEntity) break block15;
                }
                return;
            }
            LivingEntity target = (LivingEntity)entity;
            if (owner.m_213877_() || owner.m_21224_() || target.m_213877_()) {
                return;
            }
            if (this.damageDealtByOwner == 0.0f) {
                return;
            }
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            float targetStrength = BattleData.calculateStrength(target) * 1.25f;
            float ownerStrength = BattleData.calculateStrength(owner) * 0.5f;
            float experience = Math.min((float)targetStrength, (float)((targetStrength - ownerStrength) * 5.0f * (this.totalDamageDealt / this.damageDealtByOwner) * ((Double)ConfigHolder.SERVER.experienceMultiplier.get()).floatValue()));
            float rawExperience = Math.min((float)targetStrength, (float)((targetStrength - ownerStrength) * 5.0f * (this.totalDamageDealt / this.damageDealtByOwner)));
            if (target instanceof Player) {
                targetplayer = (Player)target;
                experience = (float)((double)experience * (Double)ConfigHolder.SERVER.pvpGain.get());
                rawExperience = (float)((double)rawExperience * (Double)ConfigHolder.SERVER.pvpGain.get());
            }
            if (experience < 0.1f && (Double)ConfigHolder.SERVER.minEXP.get() == 0.0) {
                return;
            }
            experience = Math.max((float)((Double)ConfigHolder.SERVER.minEXP.get()).floatValue(), (float)experience);
            if ((Double)ConfigHolder.SERVER.maxEXP.get() != 0.0) {
                experience = Math.min((float)((Double)ConfigHolder.SERVER.maxEXP.get()).floatValue(), (float)experience);
            }
            if (((Boolean)ConfigHolder.SERVER.playerRequiredForGradeUp.get()).booleanValue() && target instanceof Player) {
                SorcererGrade current;
                targetplayer = (Player)target;
                SorcererGrade previous = SorcererUtil.getGrade(cap.getExperience());
                if (previous != (current = SorcererUtil.getGrade(experience))) {
                    experience = Math.max((float)(previous.getNext().getRequiredExperience() - 0.01f - cap.getExperience()), (float)0.0f);
                }
            }
            if (cap.addExperience(experience) && owner instanceof Player) {
                Player player2 = (Player)owner;
                player2.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.experience", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(experience)}));
            }
            if ((points = (int)Math.floor((float)(rawExperience * 0.2f * ((Double)ConfigHolder.SERVER.pointMultiplier.get()).floatValue()))) > 0) {
                cap.addPoints(points);
                if (owner instanceof Player) {
                    player = (Player)owner;
                    player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.points", "jujutsu_kaisen"), (Object[])new Object[]{points}));
                }
            }
            if (owner instanceof ServerPlayer) {
                player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }

        public void attack(UUID attackerUUID, float damage) {
            this.totalDamageDealt += damage;
            if (attackerUUID.equals(this.ownerUUID)) {
                this.damageDealtByOwner += damage;
            }
        }
    }
}

