/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.cursed_speech;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.cursed_speech.CursedSpeech;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedSpeechParticle;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class BurnUp
extends CursedSpeech {
    private static final double RANGE = 30.0;
    private static final double RADIUS = 2.5;
    private static final float DAMAGE = 11.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return BurnUp.getEntities((LivingEntity)owner).contains(target) && HelperMethods.RANDOM.m_188503_(5) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private static List<Entity> getEntities(LivingEntity owner) {
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        AABB bounds = AABB.m_165882_((Vec3)src, (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(30.0)).m_82400_(2.5);
        return owner.m_9236_().m_6249_((Entity)owner, bounds, entity -> {
            LivingEntity living;
            return !(entity instanceof LivingEntity) || owner.m_6779_(living = (LivingEntity)entity);
        });
    }

    private void spawnParticles(Entity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f);
        double z = entity.m_20189_();
        for (int i = 0; i < 24; ++i) {
            double scale = HelperMethods.RANDOM.m_188500_() * 0.5 + 0.5;
            Vec3 speed = new Vec3(HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_()).m_82541_().m_82490_(scale);
            double offsetX = x + speed.f_82479_;
            double offsetY = y + speed.f_82480_;
            double offsetZ = z + speed.f_82481_;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, offsetX, offsetY, offsetZ, 0, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0);
        }
    }

    @Override
    public void run(LivingEntity owner) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 src = owner.m_146892_();
        int i = 1;
        while ((double)i < 37.0) {
            Vec3 dst = src.m_82549_(look.m_82490_((double)i));
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new CursedSpeechParticle.CursedSpeechParticleOptions(new Vector3f(1.0f, 0.514f, 0.188f), (float)(src.m_82554_(dst) * 0.5)), dst.f_82479_, dst.f_82480_, dst.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
            ++i;
        }
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, (SoundEvent)JJKSounds.CURSED_SPEECH.get(), SoundSource.MASTER, 2.0f, 0.8f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        owner.m_9236_().m_6263_(null, src.f_82479_, src.f_82480_, src.f_82481_, SoundEvents.f_12500_, SoundSource.MASTER, 1.0f, 0.5f + HelperMethods.RANDOM.m_188501_() * 0.2f);
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (Entity entity : BurnUp.getEntities(owner)) {
            LivingEntity living;
            if (entity instanceof LivingEntity && JJKAbilities.hasToggled(living = (LivingEntity)entity, (Ability)JJKAbilities.INFINITY.get())) continue;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.burn_up", "jujutsu_kaisen"), (Object[])new Object[]{owner.m_7755_()}));
            }
            cap.delayTickEvent(() -> {
                if (entity != null && entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 11.0f * this.getPower(owner))) {
                    entity.m_20254_(4);
                    this.spawnParticles(entity);
                    entity.f_19864_ = true;
                }
            }, 15);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 50.0f;
    }

    @Override
    public int getCooldown() {
        return 280;
    }

    @Override
    public int getThroatDamage() {
        return 20;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.CURSED_SPEECH;
    }
}

