/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.effect.ForestWaveEntity;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class ForestWave
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final int DELAY = 2;
    private static final int SPEED = 5;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || !owner.m_142582_((Entity)target)) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(5) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(1) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        Vec3 spawn;
        Vec3 look;
        ForestWaveEntity forest;
        int i;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        int charge = this.getCharge(owner);
        float xRot = (HelperMethods.RANDOM.m_188501_() - 0.5f) * 90.0f;
        float yRot = (HelperMethods.RANDOM.m_188501_() - 0.5f) * 90.0f;
        int n = i = charge < 5 ? 0 : -5;
        while (i <= 5) {
            forest = new ForestWaveEntity(owner, this.getPower(owner));
            look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
            spawn = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_()).m_82549_(look.m_82524_(90.0f).m_82490_((double)(-forest.m_20205_() * 1.5f))).m_82549_(look.m_82490_((double)((float)charge + (float)i * forest.m_20205_())));
            forest.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, yRot, xRot);
            forest.setDamage(charge >= 2);
            owner.m_9236_().m_7967_((Entity)forest);
            ++i;
        }
        int n2 = i = charge < 5 ? 0 : -5;
        while (i <= 5) {
            forest = new ForestWaveEntity(owner, this.getPower(owner));
            look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
            spawn = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_()).m_82549_(look.m_82524_(90.0f).m_82490_((double)(forest.m_20205_() * 1.5f))).m_82549_(look.m_82490_((double)((float)charge + (float)i * forest.m_20205_())));
            forest.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, yRot, xRot);
            forest.setDamage(charge >= 2);
            owner.m_9236_().m_7967_((Entity)forest);
            ++i;
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 5.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getDuration() {
        return 4;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.PLANTS;
    }
}

