/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.idle_transfiguration;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.base.Transformation;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class InstantSpiritBodyOfDistortedKilling
extends Transformation {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("81461f5f-89d5-4cc9-8b25-17e7caac9255");
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("84341016-e56a-4b95-9fd5-42b36154c885");
    private static final UUID STEP_HEIGHT_UUID = UUID.fromString("654c65b5-dc0f-4092-8423-59cbe3d19682");
    private static final UUID ARMOR_UUID = UUID.fromString("486fd273-fdbc-4876-b0b8-af5a64bfb08a");
    private static final UUID ARMOR_TOUGHNESS_UUID = UUID.fromString("0be71dde-8aeb-4c5d-955f-d37325c31a94");

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return target != null && !target.m_21224_() && (cap.getType() == JujutsuType.CURSE || cap.isUnlocked((Ability)JJKAbilities.RCT1.get()) ? owner.m_21223_() / owner.m_21233_() < 0.9f : owner.m_21223_() / owner.m_21233_() < 0.4f);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int count = (int)(owner.m_20205_() * owner.m_20206_()) * 8;
        for (int i = 0; i < count; ++i) {
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, 0.0, HelperMethods.RANDOM.m_188500_() * 0.1, 0.0, 1.0);
        }
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.isInZone() && super.isValid(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public boolean isReplacement() {
        return true;
    }

    @Override
    public Item getItem() {
        return (Item)JJKItems.INSTANT_SPIRIT_BODY_OF_DISTORTED_KILLING.get();
    }

    @Override
    public ITransformation.Part getBodyPart() {
        return ITransformation.Part.BODY;
    }

    @Override
    public void onRightClick(LivingEntity owner) {
    }

    @Override
    public void applyModifiers(LivingEntity owner) {
        EntityUtil.applyModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Attack damage", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtil.applyModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "Movement speed", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtil.applyModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID, "Step height addition", 2.0, AttributeModifier.Operation.ADDITION);
        EntityUtil.applyModifier(owner, Attributes.f_22284_, ARMOR_UUID, "Armor", 20.0, AttributeModifier.Operation.ADDITION);
        EntityUtil.applyModifier(owner, Attributes.f_22285_, ARMOR_TOUGHNESS_UUID, "Armor toughness", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public void removeModifiers(LivingEntity owner) {
        EntityUtil.removeModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID);
        EntityUtil.removeModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22284_, ARMOR_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22285_, ARMOR_TOUGHNESS_UUID);
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean usesHands() {
        return false;
    }
}

