/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.limitless;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.IAdditionalAdaptation;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.curse.KuchisakeOnnaEntity;
import radon.jujutsu_kaisen.entity.projectile.ThrownChainProjectile;
import radon.jujutsu_kaisen.entity.projectile.WorldSlashProjectile;
import radon.jujutsu_kaisen.entity.projectile.base.JujutsuProjectile;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.util.HelperMethods;

public class Infinity
extends Ability
implements Ability.IToggled,
IAdditionalAdaptation {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.8f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public int getAdditional() {
        return 1;
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    private static boolean canBlock(LivingEntity owner, Projectile projectile) {
        Object chain;
        if (projectile.m_19749_() == owner) {
            return false;
        }
        if (projectile instanceof WorldSlashProjectile) {
            WorldSlashProjectile slash = (WorldSlashProjectile)projectile;
            return false;
        }
        if (projectile instanceof ThrownChainProjectile && ((ThrownChainProjectile)((Object)(chain = (ThrownChainProjectile)projectile))).getStack().m_150930_((Item)JJKItems.INVERTED_SPEAR_OF_HEAVEN.get())) {
            return false;
        }
        for (KuchisakeOnnaEntity curse : owner.m_9236_().m_45976_(KuchisakeOnnaEntity.class, AABB.m_165882_((Vec3)owner.m_20182_(), (double)16.0, (double)16.0, (double)16.0))) {
            Optional<UUID> identifier = curse.getCurrent();
            if (identifier.isEmpty() || identifier.get() != owner.m_20148_() || projectile.m_19749_() != curse) continue;
            return false;
        }
        if (projectile instanceof JujutsuProjectile) {
            JujutsuProjectile jujutsu = (JujutsuProjectile)projectile;
            return !jujutsu.isDomain();
        }
        return true;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class InfinityForgeEvents {
        @SubscribeEvent
        public static void onLevelTick(TickEvent.LevelTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            Level level = event.level;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                FrozenProjectileData data = (FrozenProjectileData)level2.m_8895_().m_164861_(FrozenProjectileData::load, FrozenProjectileData::new, "frozen_projectile_data");
                data.tick(level2);
            }
        }

        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            HitResult hitResult = event.getRayTraceResult();
            if (!(hitResult instanceof EntityHitResult)) {
                return;
            }
            EntityHitResult hit = (EntityHitResult)hitResult;
            Entity entity = hit.m_82443_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)entity;
            Level level = owner.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            if (!JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.INFINITY.get())) {
                return;
            }
            FrozenProjectileData data = (FrozenProjectileData)level2.m_8895_().m_164861_(FrozenProjectileData::load, FrozenProjectileData::new, "frozen_projectile_data");
            Projectile projectile = event.getProjectile();
            if (!Infinity.canBlock(owner, projectile)) {
                return;
            }
            data.add(owner, projectile);
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity target = event.getEntity();
            Level level = target.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            FrozenProjectileData data = (FrozenProjectileData)level2.m_8895_().m_164861_(FrozenProjectileData::load, FrozenProjectileData::new, "frozen_projectile_data");
            if (!JJKAbilities.hasToggled(target, (Ability)JJKAbilities.INFINITY.get())) {
                return;
            }
            for (Projectile projectile : target.m_9236_().m_45976_(Projectile.class, target.m_20191_().m_82400_(1.0))) {
                if (!Infinity.canBlock(target, projectile)) continue;
                data.add(target, projectile);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingAttack(LivingAttackEvent event) {
            Projectile projectile;
            LivingEntity target = event.getEntity();
            if (target.m_9236_().f_46443_) {
                return;
            }
            if (!JJKAbilities.hasToggled(target, (Ability)JJKAbilities.INFINITY.get())) {
                return;
            }
            DamageSource source = event.getSource();
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                return;
            }
            Entity entity = source.m_7640_();
            if (entity instanceof Projectile && !Infinity.canBlock(target, projectile = (Projectile)entity)) {
                return;
            }
            if (source.m_7640_() instanceof DomainExpansionEntity) {
                return;
            }
            if (source.m_7639_() == target) {
                return;
            }
            entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (HelperMethods.isMelee(source) && JJKAbilities.hasToggled(living, (Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
                    return;
                }
            }
            if (!(source.m_7640_() instanceof Projectile)) {
                target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_144048_, SoundSource.MASTER, 1.0f, 1.0f);
            }
            event.setCanceled(true);
        }
    }

    public static class FrozenProjectileData
    extends SavedData {
        public static final String IDENTIFIER = "frozen_projectile_data";
        private final Map<UUID, FrozenProjectileNBT> frozen = new HashMap<UUID, FrozenProjectileNBT>();

        public static FrozenProjectileData load(CompoundTag pCompoundTag) {
            FrozenProjectileData data = new FrozenProjectileData();
            ListTag frozenTag = pCompoundTag.m_128437_("frozen", 10);
            for (Tag tag : frozenTag) {
                FrozenProjectileNBT nbt = new FrozenProjectileNBT((CompoundTag)tag);
                data.frozen.put(nbt.getTarget(), nbt);
            }
            return data;
        }

        @NotNull
        public CompoundTag m_7176_(CompoundTag pCompoundTag) {
            ListTag frozenTag = new ListTag();
            frozenTag.addAll(this.frozen.values());
            pCompoundTag.m_128365_("frozen", (Tag)frozenTag);
            return pCompoundTag;
        }

        public void add(LivingEntity source, Projectile target) {
            if (!this.frozen.containsKey(target.m_20148_())) {
                this.frozen.put(target.m_20148_(), new FrozenProjectileNBT(source, target));
                this.m_77762_();
            }
        }

        public void tick(ServerLevel level) {
            Iterator<FrozenProjectileNBT> iter = this.frozen.values().iterator();
            while (iter.hasNext()) {
                FrozenProjectileNBT nbt = iter.next();
                Entity projectile = level.m_8791_(nbt.getTarget());
                Entity entity = level.m_8791_(nbt.getSource());
                if (!(entity instanceof LivingEntity)) {
                    if (projectile != null) {
                        projectile.m_20256_(nbt.getMovement());
                        projectile.m_20242_(nbt.isNoGravity());
                    }
                    iter.remove();
                    this.m_77762_();
                    continue;
                }
                LivingEntity owner = (LivingEntity)entity;
                if (projectile == null) {
                    iter.remove();
                    this.m_77762_();
                    continue;
                }
                if (JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.INFINITY.get()) && owner.m_20270_(projectile) < 2.5f) {
                    Vec3 original = nbt.getMovement();
                    projectile.m_20256_(original.m_82490_(Double.MIN_VALUE));
                    projectile.m_20242_(true);
                    continue;
                }
                projectile.m_20256_(nbt.getMovement());
                projectile.m_20242_(nbt.isNoGravity());
                iter.remove();
                this.m_77762_();
            }
        }

        private static class FrozenProjectileNBT
        extends CompoundTag {
            public FrozenProjectileNBT(LivingEntity source, Projectile target) {
                this.m_128362_("source", source.m_20148_());
                this.m_128362_("target", target.m_20148_());
                this.m_128379_("no_gravity", target.m_20068_());
                Vec3 movement = target.m_20184_();
                this.m_128347_("movement_x", movement.f_82479_);
                this.m_128347_("movement_y", movement.f_82480_);
                this.m_128347_("movement_z", movement.f_82481_);
            }

            public FrozenProjectileNBT(CompoundTag nbt) {
                this.m_128362_("source", nbt.m_128342_("source"));
                this.m_128362_("target", nbt.m_128342_("target"));
                this.m_128379_("no_gravity", nbt.m_128471_("no_gravity"));
                this.m_128347_("movement_x", nbt.m_128459_("movement_x"));
                this.m_128347_("movement_y", nbt.m_128459_("movement_y"));
                this.m_128347_("movement_z", nbt.m_128459_("movement_z"));
            }

            public UUID getSource() {
                return this.m_128342_("source");
            }

            public UUID getTarget() {
                return this.m_128342_("target");
            }

            public boolean isNoGravity() {
                return this.m_128471_("no_gravity");
            }

            public Vec3 getMovement() {
                double x = this.m_128459_("movement_x");
                double y = this.m_128459_("movement_y");
                double z = this.m_128459_("movement_z");
                return new Vec3(x, y, z);
            }
        }
    }
}

