/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.JujutsuLightningEntity;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;
import radon.jujutsu_kaisen.util.SorcererUtil;

public class CursedEnergyFlow
extends Ability
implements Ability.IToggled {
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("641b629b-f7b7-4066-a486-8e1d670a7439");
    private static final UUID PROJECTION_STEP_HEIGHT_UUID = UUID.fromString("df3957ac-ad26-432a-a26e-711aab5dead5");
    private static final double SPEED = 0.03;
    private static final float LIGHTNING_DAMAGE = 5.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public boolean isCursedEnergyColor() {
        return true;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public void run(LivingEntity owner) {
        float scale;
        Level f2;
        if (!owner.m_9236_().m_8055_(owner.m_20183_()).m_60819_().m_76178_()) {
            Vec3 movement = owner.m_20184_();
            if (movement.f_82480_ < 0.0) {
                double amount = 0.01;
                if (owner.m_20069_()) {
                    amount = 0.15;
                }
                owner.m_20334_(movement.f_82479_, amount, movement.f_82481_);
            }
            owner.m_6853_(true);
        }
        if (owner instanceof Player) {
            Player player = (Player)owner;
            float f2 = owner.m_20096_() && !owner.m_21224_() && !owner.m_6069_() ? Math.min(0.1f, (float)owner.m_20184_().m_165924_()) : 0.0f;
            player.f_36100_ += (f2 - player.f_36100_) * 0.4f;
        }
        if (!((f2 = owner.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)f2;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        float f3 = scale = cap.isChanneling((Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get()) ? 1.4f : 1.0f;
        if (cap.getNature() == CursedEnergyNature.LIGHTNING) {
            for (int i = 0; i < 4; ++i) {
                double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f * scale);
                double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)(owner.m_20206_() * 1.25f * scale);
                double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f * scale);
                level.m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 1), x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
            }
            if (owner.m_20069_()) {
                for (Entity entity : owner.m_9236_().m_45933_((Entity)owner, owner.m_20191_().m_82400_(16.0))) {
                    if (!entity.m_20069_() || !entity.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 5.0f * this.getPower(owner))) continue;
                    for (int i = 0; i < 16; ++i) {
                        double x = entity.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(entity.m_20205_() * 2.0f);
                        double y = entity.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)(entity.m_20206_() * 1.25f);
                        double z = entity.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(entity.m_20205_() * 2.0f);
                        level.m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 1), x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
                    }
                    owner.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void applyModifiers(LivingEntity owner) {
        double newSpeed = 0.03;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.getNature() == CursedEnergyNature.DIVERGENT) {
            newSpeed *= 1.15;
        }
        float ratio = cap.getEnergy() / cap.getMaxEnergy();
        EntityUtil.applyModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PROJECTION_STEP_HEIGHT_UUID, "Step height addition", 2.0, AttributeModifier.Operation.ADDITION);
        if (cap.isChanneling((Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get()) && owner instanceof Player) {
            Player player = (Player)owner;
        } else {
            if ((double)ratio <= 0.5 && (double)ratio > 0.3) {
                newSpeed *= 0.85;
            }
            if ((double)ratio <= 0.3 && (double)ratio > 0.15) {
                newSpeed *= 0.75;
            }
            if ((double)ratio <= 0.15) {
                newSpeed *= 0.65;
            }
            if (cap.getBurnout() > 0) {
                newSpeed *= 0.8;
            }
            EntityUtil.applyModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "Movement speed", newSpeed * (double)this.getPower(owner), AttributeModifier.Operation.ADDITION);
        }
    }

    @Override
    public void removeModifiers(LivingEntity owner) {
        EntityUtil.removeModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID);
        EntityUtil.removeModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), PROJECTION_STEP_HEIGHT_UUID);
    }

    @Override
    public float getCost(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (owner.m_20069_() && cap.getNature() == CursedEnergyNature.LIGHTNING) {
            return 5.1f;
        }
        return 0.1f;
    }

    @Override
    public boolean isUnlocked(LivingEntity owner) {
        return true;
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        return true;
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(0.0f, 2.0f);
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public Ability.Status isStillUsable(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getEnergy() == 0.0f ? Ability.Status.FAILURE : super.isStillUsable(owner);
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CursedEnergyFlowForgeEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onLivingHurt(LivingHurtEvent event) {
            ISorcererData attackerCap;
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker.m_9236_().f_46443_) {
                return;
            }
            LivingEntity victim = event.getEntity();
            if (JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) && attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (HelperMethods.isMelee(source)) {
                    float increase = 2.0f * SorcererUtil.getPower(attackerCap.getExperience());
                    if (JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.ARM_BLADE.get())) {
                        increase *= 1.5f;
                    }
                    switch (attackerCap.getNature()) {
                        case ROUGH: {
                            increase *= 1.5f;
                            break;
                        }
                        case LIGHTNING: {
                            increase *= attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)JJKItems.NYOI_STAFF.get()) ? 1.5f : 1.0f;
                            break;
                        }
                        case DIVERGENT: {
                            Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)attacker);
                            attackerCap.delayTickEvent(() -> {
                                victim.f_19802_ = 0;
                                Vec3 pos = victim.m_20182_().m_82520_(0.0, (double)(victim.m_20206_() / 2.0f), 0.0);
                                if (victim.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(attacker, null), event.getAmount())) {
                                    ((ServerLevel)victim.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 1.0, 0.0, 0.0, 1.0);
                                    victim.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
                                    victim.m_20256_(look.m_82490_((double)(1.0f + attackerCap.getAbilityPower() * 0.05f)));
                                    victim.f_19864_ = true;
                                }
                            }, 8);
                        }
                    }
                    if (attacker instanceof Player) {
                        Player player = (Player)attacker;
                        if (!player.m_150110_().f_35937_) {
                            // empty if block
                        }
                    }
                    event.setAmount(event.getAmount() + increase);
                }
            }
            if (HelperMethods.isMelee(source) && attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) && attackerCap.getNature() == CursedEnergyNature.LIGHTNING) {
                    victim.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 9 * (attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)JJKItems.NYOI_STAFF.get()) ? 2 : 1), 0, false, false, false));
                    victim.m_5496_(SoundEvents.f_12089_, 1.0f, 0.5f + HelperMethods.RANDOM.m_188501_() * 0.2f);
                    if (!attacker.m_9236_().f_46443_) {
                        for (int i = 0; i < 8; ++i) {
                            double offsetX = HelperMethods.RANDOM.m_188583_() * 1.5;
                            double offsetY = HelperMethods.RANDOM.m_188583_() * 1.5;
                            double offsetZ = HelperMethods.RANDOM.m_188583_() * 1.5;
                            ((ServerLevel)attacker.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColor((Entity)attacker), 0.5f, 1), victim.m_20185_() + offsetX, victim.m_20186_() + offsetY, victim.m_20189_() + offsetZ, 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (source.m_269533_(DamageTypeTags.f_268490_)) {
                return;
            }
            if (JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get()) && victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                JJKDamageSources.JujutsuDamageSource jujutsu;
                ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (victimCap.getNature() == CursedEnergyNature.LIGHTNING && (source.m_7640_() instanceof JujutsuLightningEntity || source instanceof JJKDamageSources.JujutsuDamageSource && (jujutsu = (JJKDamageSources.JujutsuDamageSource)source).getAbility() != null && jujutsu.getAbility().getClassification() == Ability.Classification.LIGHTNING)) {
                    event.setCanceled(true);
                }
                if (HelperMethods.isMelee(source)) {
                    switch (victimCap.getNature()) {
                        case ROUGH: {
                            attacker.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(victim, null), 1.0f + victimCap.getExperience() * 0.0025f);
                        }
                    }
                }
                float armor = !source.m_269533_(DamageTypeTags.f_276146_) && victimCap.isChanneling((Ability)JJKAbilities.CURSED_ENERGY_SHIELD.get()) ? 2.5f : 1.2f;
                armor = !source.m_269533_(DamageTypeTags.f_276146_) && victimCap.isChanneling((Ability)JJKAbilities.WATER_SHIELD.get()) ? 2.5f : armor;
                float block = event.getAmount() / armor;
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    if (!player.m_150110_().f_35937_) {
                        // empty if block
                    }
                }
                event.setAmount(block);
            }
        }
    }
}

