/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.mythical_beast_amber;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransformation;
import radon.jujutsu_kaisen.ability.base.Transformation;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.entity.sorcerer.HeianSukunaEntity;
import radon.jujutsu_kaisen.entity.sorcerer.SukunaEntity;
import radon.jujutsu_kaisen.item.JJKItems;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.EntityUtil;
import radon.jujutsu_kaisen.util.HelperMethods;

public class MythicalBeastAmber
extends Transformation {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("81461f5f-89d5-4cc9-8b25-17e7caac9255");
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("84341016-e56a-4b95-9fd5-42b36154c885");
    private static final UUID STEP_HEIGHT_UUID = UUID.fromString("654c65b5-dc0f-4092-8423-59cbe3d19682");
    private static final UUID ARMOR_UUID = UUID.fromString("486fd273-fdbc-4876-b0b8-af5a64bfb08a");
    private static final UUID ARMOR_TOUGHNESS_UUID = UUID.fromString("0be71dde-8aeb-4c5d-955f-d37325c31a94");
    private final Set<LivingEntity> glowingEntities = new HashSet<LivingEntity>();
    private int r;
    private int g;
    private int b;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (JJKAbilities.hasToggled((LivingEntity)owner, this)) {
            return true;
        }
        if (target == null) return false;
        if (target instanceof SukunaEntity) {
            SukunaEntity sukun = (SukunaEntity)target;
            return true;
        } else {
            if (!(target instanceof HeianSukunaEntity)) return false;
            HeianSukunaEntity bigsuku = (HeianSukunaEntity)target;
        }
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        HashSet<LivingEntity> newGlows = new HashSet<LivingEntity>();
        for (Entity entity : owner.m_9236_().m_45933_(null, owner.m_20191_().m_82400_(15.0))) {
            LivingEntity living;
            if (!entity.m_6084_() || !(entity instanceof LivingEntity) || (living = (LivingEntity)entity) == owner) continue;
            if (!this.glowingEntities.contains(living)) {
                living.m_146915_(true);
            }
            newGlows.add(living);
        }
        for (LivingEntity prev : this.glowingEntities) {
            if (newGlows.contains(prev) || !prev.m_6084_()) continue;
            prev.m_146915_(false);
        }
        this.glowingEntities.clear();
        this.glowingEntities.addAll(newGlows);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 2.0f;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public boolean isReplacement() {
        return false;
    }

    @Override
    public Item getItem() {
        return (Item)JJKItems.MYTHICAL_BEAST_AMBER.get();
    }

    @Override
    public ITransformation.Part getBodyPart() {
        return ITransformation.Part.BODY;
    }

    @Override
    public void onRightClick(LivingEntity owner) {
    }

    @Override
    public void applyModifiers(LivingEntity owner) {
        EntityUtil.applyModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Attack damage", 1.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtil.applyModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "Movement speed", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtil.applyModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID, "Step height addition", 2.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public void removeModifiers(LivingEntity owner) {
        EntityUtil.removeModifier(owner, Attributes.f_22281_, ATTACK_DAMAGE_UUID);
        EntityUtil.removeModifier(owner, Attributes.f_22279_, MOVEMENT_SPEED_UUID);
        EntityUtil.removeModifier(owner, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), STEP_HEIGHT_UUID);
    }

    @Override
    public void onEnabled(LivingEntity owner) {
        Vector3f oldcolor = ParticleColors.getCursedEnergyColor((Entity)owner);
        this.r = (int)((double)oldcolor.x * 255.0);
        this.g = (int)((double)oldcolor.y * 255.0);
        this.b = (int)((double)oldcolor.z * 255.0);
        this.r = Math.max(0, Math.min(255, this.r));
        this.g = Math.max(0, Math.min(255, this.g));
        this.b = Math.max(0, Math.min(255, this.b));
        int color = FastColor.ARGB32.m_13660_((int)255, (int)Math.round(156.0f), (int)Math.round(95.0f), (int)Math.round(255.0f));
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.setCursedEnergyColor(color);
        cap.maxOutput();
    }

    @Override
    public void onDisabled(LivingEntity owner) {
        for (LivingEntity entity : this.glowingEntities) {
            if (!entity.m_6084_()) continue;
            entity.m_146915_(false);
        }
        this.glowingEntities.clear();
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (((Boolean)ConfigHolder.SERVER.MBAEXPReset.get()).booleanValue()) {
            ownerCap.setExperience(0.0f);
        }
        int color = FastColor.ARGB32.m_13660_((int)255, (int)Math.round(this.r), (int)Math.round(this.g), (int)Math.round(this.b));
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.setCursedEnergyColor(color);
        if (owner instanceof ServerPlayer) {
            ServerPlayer play = (ServerPlayer)owner;
            if (((Boolean)ConfigHolder.SERVER.MBAReroll.get()).booleanValue()) {
                cap.generate(play);
            }
        }
        owner.m_6074_();
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SoulReinforcementForgeEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onLivingDamage(LivingDamageEvent event) {
            Object jujutsu;
            DamageSource source = event.getSource();
            LivingEntity victim = event.getEntity();
            if (victim.m_9236_().f_46443_) {
                return;
            }
            if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData victimCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!victimCap.hasToggled((Ability)JJKAbilities.MYTHICAL_BEAST_AMBER.get())) {
                return;
            }
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                    return;
                }
                ISorcererData attackerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
                if (HelperMethods.isMelee(source) && attackerCap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
                    return;
                }
            }
            if (source.m_276093_(JJKDamageSources.SOUL) || source.m_276093_(JJKDamageSources.SPLIT_SOUL_KATANA) || source instanceof JJKDamageSources.JujutsuDamageSource && ((JJKDamageSources.JujutsuDamageSource)((Object)(jujutsu = (JJKDamageSources.JujutsuDamageSource)source))).getAbility() == JJKAbilities.OUTPUT_RCT.get()) {
                return;
            }
            for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)victim.m_9236_(), victim.m_20183_())) {
                if (domain.getOwner() != source.m_7639_()) continue;
                return;
            }
            float cost = event.getAmount() * 10.0f * (victimCap.hasTrait(Trait.SIX_EYES) ? ((Double)ConfigHolder.SERVER.sixEyesMult.get()).floatValue() : 1.0f);
            if (victimCap.getEnergy() < cost) {
                return;
            }
            victimCap.useEnergy(cost);
            int count = 8 + (int)(victim.m_20205_() * victim.m_20206_()) * 16;
            for (int i = 0; i < count; ++i) {
                double x = victim.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(victim.m_20205_() * 2.0f) - victim.m_20154_().m_82490_((double)0.35).f_82479_;
                double y = victim.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)victim.m_20206_();
                double z = victim.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(victim.m_20205_() * 2.0f) - victim.m_20154_().m_82490_((double)0.35).f_82481_;
                ((ServerLevel)victim.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(victim), 0.2f, 1), x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
            }
            victim.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 1.0f, 1.0f);
            if (victim instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)victim;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(victimCap.serializeNBT()), player);
            }
            event.setCanceled(true);
        }
    }
}

