/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shrine;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.projectile.DismantleProjectile;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class DismantleNet
extends Ability {
    private static final int MIN_SIZE = 5;
    private static final int MAX_SIZE = 20;
    private static final int SIZE = 10;
    private static final int STARTUP = 10;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(5) == 0 && target != null;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        int size = Math.max(5, Math.min(20, (int)(10.0f * this.getPower(owner))));
        int count = size / 2;
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 center = new Vec3(owner.m_20185_(), owner.m_20188_(), owner.m_20189_()).m_82549_(look);
        Vec3 xAxis = owner.m_20289_(1.0f);
        Vec3 yAxis = look.m_82537_(xAxis).m_82541_();
        float power = this.getPower(owner) * 1.9f;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < count; ++j) {
                double xOffset = ((double)i - (double)(count - 1) / 2.0) * (double)size / (double)count;
                double yOffset = ((double)j - (double)(count - 1) / 2.0) * (double)size / (double)count;
                Vec3 position = center.m_82549_(xAxis.m_82490_(xOffset)).m_82549_(yAxis.m_82490_(yOffset));
                DismantleProjectile horizontal = new DismantleProjectile(owner, power, 0.0f, position, size);
                DismantleProjectile vertical = new DismantleProjectile(owner, power, 90.0f, position, size);
                horizontal.setDuration(20);
                vertical.setDuration(20);
                horizontal.setCanHurt(false);
                vertical.setCanHurt(false);
                cap.delayTickEvent(() -> {
                    horizontal.m_20256_(look.m_82490_(5.0));
                    vertical.m_20256_(look.m_82490_(5.0));
                    horizontal.setCanHurt(true);
                    vertical.setCanHurt(true);
                }, 10);
                horizontal.m_20256_(look.m_82490_(0.0));
                vertical.m_20256_(look.m_82490_(0.0));
                owner.m_9236_().m_7967_((Entity)horizontal);
                owner.m_9236_().m_7967_((Entity)vertical);
            }
        }
        if (!owner.m_9236_().f_46443_) {
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.SLASH.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 450.0f;
    }

    @Override
    public int getCooldown() {
        return 600;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.SLASHING;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }
}

