/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.shrine;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.MalevolentShrineEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class MalevolentShrine
extends DomainExpansion
implements DomainExpansion.IOpenDomain {
    public static final int DELAY = 40;
    private static final int INTERVAL = 5;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        boolean enemyDomain = false;
        DomainExpansionEntity selfDomain = null;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                selfDomain = domain;
                continue;
            }
            if (domain.getOwner() == owner) continue;
            enemyDomain = true;
        }
        if (enemyDomain) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (cap.hasToggled((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get())) {
                cap.toggle((Ability)JJKAbilities.DOMAIN_AMPLIFICATION.get());
            }
            if (!cap.hasToggled(this)) {
                return true;
            }
            if (cap.hasToggled(this)) {
                return false;
            }
        } else if (selfDomain != null && !enemyDomain) {
            if (target != null) {
                return (double)selfDomain.m_20270_((Entity)target) >= 96.0;
            }
            if (target == null) {
                return HelperMethods.RANDOM.m_188503_(15) == 0;
            }
        }
        return target != null && (double)owner.m_20270_((Entity)target) <= 25.0 && owner.m_21223_() / owner.m_21233_() < 0.9f && HelperMethods.RANDOM.m_188503_(4) == 0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        super.onHitEntity(domain, owner, entity, instant);
        if (instant || domain.getTime() == 40 || domain.m_9236_().m_46467_() % 5L == 0L && domain.getTime() >= 40) {
            Ability cleave = (Ability)JJKAbilities.CLEAVE.get();
            ((Ability.IDomainAttack)((Object)cleave)).performEntity(owner, entity, domain);
        }
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
        if (HelperMethods.RANDOM.m_188503_(10) != 0) {
            return;
        }
        Ability dismantle = (Ability)JJKAbilities.DISMANTLE.get();
        ((Ability.IDomainAttack)((Object)dismantle)).performBlock(owner, domain, pos);
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        int width = Math.round((float)this.getWidth() * cap.getDomainSize());
        int height = Math.round((float)this.getHeight() * cap.getDomainSize());
        MalevolentShrineEntity domain = new MalevolentShrineEntity(owner, this, width, height);
        owner.m_9236_().m_7967_((Entity)domain);
        return domain;
    }

    @Override
    public int getWidth() {
        return 112;
    }

    @Override
    public int getHeight() {
        return 85;
    }
}

