/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.ten_shadows.summon;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.ten_shadows.ITenShadowsData;
import radon.jujutsu_kaisen.capability.data.ten_shadows.TenShadowsDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.ten_shadows.DivineDogBlackEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.DivineDogEntity;
import radon.jujutsu_kaisen.entity.ten_shadows.DivineDogWhiteEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class DivineDogs
extends Summon<DivineDogEntity> {
    public DivineDogs() {
        super(DivineDogEntity.class);
    }

    @Override
    public boolean canDisable() {
        return false;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (JJKAbilities.hasToggled((LivingEntity)owner, this)) {
            return target != null && !target.m_21224_() && HelperMethods.RANDOM.m_188503_(1) == 0;
        }
        return target != null && !target.m_21224_() && HelperMethods.RANDOM.m_188503_(5) == 0;
    }

    @Override
    public float getCost(LivingEntity owner) {
        float normalcost = 0.2f;
        return normalcost;
    }

    @Override
    public int getCooldown() {
        return 400;
    }

    @Override
    protected DivineDogEntity summon(LivingEntity owner) {
        return null;
    }

    @Override
    protected boolean isDead(LivingEntity owner, EntityType<?> type) {
        Registry registry;
        if (!owner.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ITenShadowsData cap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.isDead(registry = owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_), (EntityType)JJKEntities.DIVINE_DOG_WHITE.get()) && cap.isDead(registry, (EntityType)JJKEntities.DIVINE_DOG_BLACK.get());
    }

    @Override
    public void spawn(LivingEntity owner, boolean clone) {
        if (!owner.m_9236_().f_46443_) {
            ITenShadowsData tenShadowsCap = (ITenShadowsData)owner.getCapability(TenShadowsDataHandler.INSTANCE).resolve().orElseThrow();
            ISorcererData sorcererCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            Registry registry = owner.m_9236_().m_9598_().m_175515_(Registries.f_256939_);
            if (!tenShadowsCap.isDead(registry, (EntityType)JJKEntities.DIVINE_DOG_WHITE.get())) {
                DivineDogWhiteEntity white = new DivineDogWhiteEntity(owner, false);
                white.setClone(clone);
                owner.m_9236_().m_7967_((Entity)white);
                sorcererCap.addSummon((Entity)white);
            }
            if (!tenShadowsCap.isDead(registry, (EntityType)JJKEntities.DIVINE_DOG_BLACK.get())) {
                DivineDogBlackEntity black = new DivineDogBlackEntity(owner, false);
                black.setClone(clone);
                owner.m_9236_().m_7967_((Entity)black);
                sorcererCap.addSummon((Entity)black);
            }
        }
    }

    @Override
    public void onDisabled(LivingEntity owner) {
        if (!owner.m_9236_().f_46443_) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.unsummonByClass(DivineDogWhiteEntity.class);
            cap.unsummonByClass(DivineDogBlackEntity.class);
            if (owner instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
            }
        }
    }

    @Override
    public List<EntityType<?>> getTypes() {
        return List.of((EntityType)JJKEntities.DIVINE_DOG_WHITE.get(), (EntityType)JJKEntities.DIVINE_DOG_BLACK.get());
    }

    @Override
    public boolean canDie() {
        return true;
    }

    @Override
    public boolean isTenShadows() {
        return true;
    }
}

