/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.base;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.ITransfiguredSoul;
import radon.jujutsu_kaisen.ability.base.Summon;
import radon.jujutsu_kaisen.ability.cursed_speech.ICursedSpeech;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.DisplayItem;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.UncopyAbilityC2SPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public abstract class RadialScreen
extends Screen {
    protected static final int RADIUS_IN = 20;
    protected static final int RADIUS_OUT = 100;
    private final List<List<DisplayItem>> pages = new ArrayList<List<DisplayItem>>();
    protected int hovered = -1;
    private static int page;
    private int hover;
    private long lastPageSwitchTime = 0L;
    private static final long PAGE_SWITCH_INTERVAL_MS = 500L;

    public RadialScreen() {
        super(Component.m_130674_(null));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double x, double y, double delta) {
        int i = (int)Math.signum(delta);
        if (this.pages.size() > 1 && i != 0) {
            if (this.pages.size() - 1 > page && delta < 0.0) {
                ++page;
            }
            if (page > 0 && delta > 0.0) {
                --page;
            }
        }
        return false;
    }

    protected void m_7856_() {
        int index;
        super.m_7856_();
        List<DisplayItem> items = this.getItems();
        int count = items.size() / 12;
        for (int i = 0; i < count; ++i) {
            index = i * 12;
            this.pages.add(items.subList(index, index + 12));
        }
        int remainder = items.size() % 12;
        if (remainder > 0) {
            index = count * 12;
            this.pages.add(items.subList(index, index + remainder));
        }
        if (page >= this.pages.size()) {
            page = 0;
        }
        if (this.pages.isEmpty()) {
            this.m_7379_();
        }
    }

    public List<DisplayItem> getCurrent() {
        return this.pages.get(page);
    }

    protected abstract List<DisplayItem> getItems();

    private void drawSlot(PoseStack poseStack, BufferBuilder buffer, float centerX, float centerY, float startAngle, float endAngle, int color) {
        float angle = endAngle - startAngle;
        float precision = 0.0069444445f;
        int sections = Math.max(1, Mth.m_14167_((float)(angle / precision)));
        angle = endAngle - startAngle;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        float slice = angle / (float)sections;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i * slice;
            float angle2 = startAngle + (float)(i + 1) * slice;
            float x1 = centerX + 20.0f * (float)Math.cos(angle1);
            float y1 = centerY + 20.0f * (float)Math.sin(angle1);
            float x2 = centerX + 100.0f * (float)Math.cos(angle1);
            float y2 = centerY + 100.0f * (float)Math.sin(angle1);
            float x3 = centerX + 100.0f * (float)Math.cos(angle2);
            float y3 = centerY + 100.0f * (float)Math.sin(angle2);
            float x4 = centerX + 20.0f * (float)Math.cos(angle2);
            float y4 = centerY + 20.0f * (float)Math.sin(angle2);
            Matrix4f pose = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(pose, x2, y2, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x1, y1, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x4, y4, 0.0f).m_6122_(r, g, b, a).m_5752_();
            buffer.m_252986_(pose, x3, y3, 0.0f).m_6122_(r, g, b, a).m_5752_();
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ISorcererData cap = (ISorcererData)this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (this.hovered >= 0 && this.hovered < this.getCurrent().size()) {
                DisplayItem item = this.getCurrent().get(this.hovered);
                if (pButton == 1 && item.type == DisplayItem.Type.COPIED) {
                    PacketHandler.sendToServer(new UncopyAbilityC2SPacket(item.copied));
                    cap.uncopy(item.copied);
                }
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private static void renderEntityInInventoryFollowsAngle(PoseStack pPoseStack, int pX, int pY, int pScale, float angleXComponent, float angleYComponent, Entity pEntity) {
        LivingEntity living;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        if (pEntity instanceof LivingEntity) {
            living = (LivingEntity)pEntity;
            living.f_20883_ = 180.0f + angleXComponent * 20.0f;
        }
        pEntity.m_146922_(180.0f + angleXComponent * 40.0f);
        pEntity.m_146926_(-angleYComponent * 20.0f);
        if (pEntity instanceof LivingEntity) {
            living = (LivingEntity)pEntity;
            living.f_20885_ = pEntity.m_146908_();
            living.f_20886_ = pEntity.m_146908_();
        }
        RadialScreen.renderEntityInInventory(pPoseStack, pX, pY, pScale, quaternionf, quaternionf1, pEntity);
    }

    private static void renderEntityInInventory(PoseStack pPoseStack, int pX, int pY, int pScale, Quaternionf p_275229_, @Nullable Quaternionf pCameraOrientation, Entity pEntity) {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85837_(0.0, 0.0, 1000.0);
        RenderSystem.applyModelViewMatrix();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)pX, (double)pY, -950.0);
        pPoseStack.m_252931_(new Matrix4f().scaling((float)pScale, (float)pScale, (float)(-pScale)));
        pPoseStack.m_252781_(p_275229_);
        Lighting.m_166384_();
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        if (pCameraOrientation != null) {
            pCameraOrientation.conjugate();
            dispatcher.m_252923_(pCameraOrientation);
        }
        dispatcher.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> dispatcher.m_114384_(pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pPoseStack, (MultiBufferSource)buffer, 0xF000F0));
        buffer.m_109911_();
        dispatcher.m_114468_(true);
        pPoseStack.m_85849_();
        Lighting.m_84931_();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    protected boolean isActive(DisplayItem item) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return false;
        }
        ISorcererData cap = (ISorcererData)this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return item.type == DisplayItem.Type.ABILITY && JJKAbilities.hasToggled((LivingEntity)this.f_96541_.f_91074_, item.ability) || item.type == DisplayItem.Type.COPIED && cap.getCurrentCopied() == item.copied || item.type == DisplayItem.Type.ABSORBED && cap.getCurrentAbsorbed() == item.absorbed || item.type == DisplayItem.Type.STOLEN && cap.getCurrentStolen() == item.stolen;
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTicks);
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (!this.f_96541_.f_91074_.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.m_280168_().m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < this.getCurrent().size(); ++i) {
            float startAngle = this.getAngleFor((float)i - 0.5f);
            float endAngle = this.getAngleFor((float)i + 0.5f);
            DisplayItem item = this.getCurrent().get(i);
            int white = HelperMethods.toRGB24(255, 255, 255, 150);
            int black = HelperMethods.toRGB24(0, 0, 0, 150);
            int color = this.isActive(item) ? (this.hovered == i ? black : white) : (this.hovered == i ? white : black);
            this.drawSlot(pGuiGraphics.m_280168_(), buffer, centerX, centerY, startAngle, endAngle, color);
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        pGuiGraphics.m_280168_().m_85849_();
        if (this.pages.size() > 1) {
            if (this.pages.size() - 1 > page) {
                String symbol = ">";
                int x = centerX + 100 + 20;
                Objects.requireNonNull(this.f_96541_.f_91062_);
                int y = centerY - 9;
                pGuiGraphics.m_280137_(this.f_96547_, symbol, x, y, 0xFFFFFF);
            }
            if (page > 0) {
                String symbol = "<";
                int x = centerX - 100 - 20;
                Objects.requireNonNull(this.f_96541_.f_91062_);
                int y = centerY - 9;
                pGuiGraphics.m_280137_(this.f_96547_, symbol, x, y, 0xFFFFFF);
            }
        }
        float radius = 60.0f;
        for (int i = 0; i < this.getCurrent().size(); ++i) {
            Summon summon;
            float start = this.getAngleFor((float)i - 0.5f);
            float end = this.getAngleFor((float)i + 0.5f);
            float middle = (start + end) / 2.0f;
            int posX = (int)((float)centerX + radius * (float)Math.cos(middle));
            int posY = (int)((float)centerY + radius * (float)Math.sin(middle));
            DisplayItem item = this.getCurrent().get(i);
            if (this.hovered == i) {
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                if (item.type == DisplayItem.Type.ABILITY) {
                    Ability.IDurationable durationable;
                    int n;
                    int cooldown;
                    float cost = item.ability.getRealCost((LivingEntity)this.f_96541_.f_91074_);
                    if (cost > 0.0f) {
                        lines.add(Component.m_237110_((String)String.format("gui.%s.ability_overlay.cost", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(cost)}));
                    }
                    if ((cooldown = item.ability.getRealCooldown((LivingEntity)this.f_96541_.f_91074_)) > 0) {
                        lines.add(Component.m_237110_((String)String.format("gui.%s.ability_overlay.cooldown", "jujutsu_kaisen"), (Object[])new Object[]{Math.round((float)cooldown / 20.0f)}));
                    }
                    if (item instanceof Ability.IDurationable && (n = (durationable = (Ability.IDurationable)((Object)item)).getRealDuration((LivingEntity)this.f_96541_.f_91074_)) > 0) {
                        MutableComponent durationText = Component.m_237110_((String)String.format("gui.%s.ability_overlay.duration", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf((float)n / 20.0f)});
                        lines.add(durationText);
                    }
                    if (item instanceof ITransfiguredSoul) {
                        ITransfiguredSoul soul = (ITransfiguredSoul)((Object)item);
                        MutableComponent mutableComponent = Component.m_237110_((String)String.format("gui.%s.ability_overlay.soul_cost", "jujutsu_kaisen"), (Object[])new Object[]{soul.getSoulCost()});
                        lines.add(mutableComponent);
                    }
                    if (item instanceof ICursedSpeech) {
                        ICursedSpeech speech = (ICursedSpeech)((Object)item);
                        MutableComponent mutableComponent = Component.m_237110_((String)String.format("gui.%s.ability_overlay.throat_damage", "jujutsu_kaisen"), (Object[])new Object[]{speech.getThroatDamage()});
                        lines.add(mutableComponent);
                    }
                } else if (item.type == DisplayItem.Type.CURSE) {
                    MutableComponent costText = Component.m_237110_((String)String.format("gui.%s.ability_overlay.cost", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(JJKAbilities.getCurseCost(item.curse.getKey()))});
                    lines.add(costText);
                    MutableComponent experienceText = Component.m_237110_((String)String.format("gui.%s.ability_overlay.experience", "jujutsu_kaisen"), (Object[])new Object[]{Float.valueOf(JJKAbilities.getCurseExperience(item.curse.getKey()))});
                    lines.add(experienceText);
                }
                int x = this.f_96543_ / 2;
                int n = this.f_96544_ / 2;
                Objects.requireNonNull(this.f_96547_);
                int n2 = n - 9 / 2;
                int n3 = lines.size() - 1;
                Objects.requireNonNull(this.f_96547_);
                int y = n2 - n3 * 9;
                for (Component component : lines) {
                    pGuiGraphics.m_280653_(this.f_96547_, component, x, y, 0xFFFFFF);
                    Objects.requireNonNull(this.f_96547_);
                    y += 9;
                }
            }
            if (item.type == DisplayItem.Type.CURSE) {
                CursedSpirit entity = JJKAbilities.createCurse((LivingEntity)this.f_96541_.f_91074_, item.curse.getKey());
                if (entity == null) continue;
                float height = entity.m_20206_();
                int scale = (int)Math.max(3.0f, 10.0f - entity.m_20206_());
                RadialScreen.renderEntityInInventoryFollowsAngle(pGuiGraphics.m_280168_(), posX, (int)((float)posY + height * (float)scale / 2.0f), scale, -1.0f, -0.5f, (Entity)entity);
                continue;
            }
            Ability entity = item.ability;
            if (entity instanceof Summon && (summon = (Summon)entity).display()) {
                entity = ((Summon)item.ability).getTypes().get(0).m_20615_((Level)this.f_96541_.f_91073_);
                if (entity == null) continue;
                float height = entity.m_20206_();
                int scale = (int)Math.max(3.0f, 10.0f - entity.m_20206_());
                RadialScreen.renderEntityInInventoryFollowsAngle(pGuiGraphics.m_280168_(), posX, (int)((float)posY + height * (float)scale / 2.0f), scale, -1.0f, -0.5f, (Entity)entity);
                continue;
            }
            if (item.type == DisplayItem.Type.ABILITY) {
                Objects.requireNonNull(this.f_96547_);
                int y = posY - 9 / 2;
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.0f);
                pGuiGraphics.m_280168_().m_252880_((float)posX, (float)y, 0.0f);
                pGuiGraphics.m_280653_(this.f_96547_, item.ability.getName(), posX, y, 0xFFFFFF);
                pGuiGraphics.m_280168_().m_85849_();
                continue;
            }
            if (item.type != DisplayItem.Type.COPIED && item.type != DisplayItem.Type.ABSORBED && item.type != DisplayItem.Type.STOLEN) continue;
            Objects.requireNonNull(this.f_96547_);
            int y = posY - 9 / 2;
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.0f);
            pGuiGraphics.m_280168_().m_252880_((float)posX, (float)y, 0.0f);
            pGuiGraphics.m_280653_(this.f_96547_, item.type == DisplayItem.Type.COPIED ? item.copied.getName() : (item.type == DisplayItem.Type.STOLEN ? item.stolen.getName() : item.absorbed.getName()), posX, y, 0xAA00AA);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_94757_(double pMouseX, double pMouseY) {
        double mouseAngle;
        super.m_94757_(pMouseX, pMouseY);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        double mousePos = Math.sqrt(Math.pow(pMouseX - (double)centerX, 2.0) + Math.pow(pMouseY - (double)centerY, 2.0));
        if (this.getCurrent().isEmpty()) {
            return;
        }
        float startAngle = this.getAngleFor(-0.5);
        float endAngle = this.getAngleFor((float)this.getCurrent().size() - 0.5f);
        for (mouseAngle = Math.atan2(pMouseY - (double)centerY, pMouseX - (double)centerX); mouseAngle < (double)startAngle; mouseAngle += 6.2831854820251465) {
        }
        while (mouseAngle >= (double)endAngle) {
            mouseAngle -= 6.2831854820251465;
        }
        this.hovered = -1;
        for (int i = 0; i < this.getCurrent().size(); ++i) {
            float currentStart = this.getAngleFor((float)i - 0.5f);
            float currentEnd = this.getAngleFor((float)i + 0.5f);
            if (!(mouseAngle >= (double)currentStart) || !(mouseAngle < (double)currentEnd) || !(mousePos >= 20.0)) continue;
            this.hovered = i;
            break;
        }
        if (mousePos < 100.0) {
            return;
        }
        if (this.pages.size() <= 1) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean switched = false;
        if (this.pages.size() - 1 > page && pMouseX > (double)this.f_96543_ / 2.0 && pMouseX < (double)this.f_96543_ && pMouseY > 0.0 && pMouseY < (double)this.f_96544_ && now - this.lastPageSwitchTime >= 500L) {
            ++page;
            this.lastPageSwitchTime = now;
            switched = true;
        }
        if (!switched && page > 0 && pMouseX > 0.0 && pMouseX < (double)this.f_96543_ / 2.0 && pMouseY > 0.0 && pMouseY < (double)this.f_96544_ && now - this.lastPageSwitchTime >= 500L) {
            --page;
            this.lastPageSwitchTime = now;
        }
        if (!(pMouseX < (double)this.f_96543_ / 2.0 && page > 0 || pMouseX > (double)this.f_96543_ / 2.0 && this.pages.size() - 1 > page)) {
            this.lastPageSwitchTime = 0L;
        }
    }

    private float getAngleFor(double i) {
        if (this.getCurrent().isEmpty()) {
            return 0.0f;
        }
        return (float)((i / (double)this.getCurrent().size() + 0.25) * 6.2831854820251465 + Math.PI);
    }
}

