/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.screen.tab;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.gui.screen.JujutsuScreen;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTab;
import radon.jujutsu_kaisen.client.gui.screen.tab.JJKTabType;
import radon.jujutsu_kaisen.client.gui.screen.widget.JJKSelectionList;
import radon.jujutsu_kaisen.client.gui.screen.widget.PactListWidget;
import radon.jujutsu_kaisen.client.gui.screen.widget.PlayerListWidget;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.c2s.QuestionCreatePactC2SPacket;
import radon.jujutsu_kaisen.network.packet.c2s.QuestionRemovePactC2SPacket;

public class PactTab
extends JJKTab {
    private static final Component TITLE = Component.m_237115_((String)String.format("gui.%s.pact", "jujutsu_kaisen"));
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/advancements/backgrounds/stone.png");
    private Button create;
    private Button remove;
    private MultiLineTextWidget description;
    @Nullable
    private PlayerListWidget.Entry player;
    @Nullable
    private PactListWidget.Entry pact;

    public PactTab(Minecraft minecraft, JujutsuScreen screen, JJKTabType type, int index, int page) {
        super(minecraft, screen, type, index, page, Items.f_42614_.m_7968_(), TITLE, BACKGROUND, false);
    }

    @Nullable
    public PlayerListWidget.Entry getSelectedPlayer() {
        return this.player;
    }

    public void setSelectedPlayer(PlayerListWidget.Entry entry) {
        this.player = entry;
    }

    public void setSelectedPact(PactListWidget.Entry entry) {
        this.pact = entry;
        this.description.m_93666_(entry.get().getDescription());
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildPlayerList(Consumer<T> consumer, Function<PlayerInfo, T> result) {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        ClientPacketListener connection = this.minecraft.m_91403_();
        if (connection == null) {
            return;
        }
        for (PlayerInfo player : connection.m_105142_()) {
            if (player.m_105312_().getId().equals(this.minecraft.f_91074_.m_20148_())) continue;
            consumer.accept((ObjectSelectionList.Entry)result.apply(player));
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildPactList(Consumer<T> consumer, Function<Pact, T> result) {
        for (Pact pact : Pact.values()) {
            consumer.accept((ObjectSelectionList.Entry)result.apply(pact));
        }
    }

    @Override
    public void drawContents(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.drawContents(pGuiGraphics, pX, pY);
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.pact.players", "jujutsu_kaisen")), xOffset, yOffset, 0xFFFFFF, true);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)Component.m_237115_((String)String.format("gui.%s.pact.pacts", "jujutsu_kaisen")), xOffset + 64, yOffset, 0xFFFFFF, true);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        this.create.f_93623_ = false;
        this.remove.f_93623_ = false;
        if (this.player != null && this.pact != null) {
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            this.create.f_93623_ = !cap.hasPact(this.player.get().m_105312_().getId(), this.pact.get());
            this.remove.f_93623_ = cap.hasPact(this.player.get().m_105312_().getId(), this.pact.get());
        }
    }

    @Override
    public void addWidgets() {
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 140) / 2;
        int xOffset = i + 18;
        int yOffset = j + 27;
        JJKSelectionList.IBuilder<PlayerInfo, PlayerListWidget.Entry> iBuilder = this::buildPlayerList;
        JJKSelectionList.ICallback<PlayerListWidget.Entry> iCallback = this::setSelectedPlayer;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.addRenderableWidget(new PlayerListWidget(iBuilder, iCallback, this.minecraft, 56, 85, xOffset, yOffset + 9 + 1));
        JJKSelectionList.IBuilder<Pact, PactListWidget.Entry> iBuilder2 = this::buildPactList;
        JJKSelectionList.ICallback<PactListWidget.Entry> iCallback2 = this::setSelectedPact;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.addRenderableWidget(new PactListWidget(iBuilder2, iCallback2, this.minecraft, 56, 85, xOffset + 64, yOffset + 9 + 1, this));
        Button.Builder builder = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.pact.create", "jujutsu_kaisen")), pButton -> {
            if (this.player == null || this.pact == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.pact_request_create", "jujutsu_kaisen"), (Object[])new Object[]{this.player.get().m_105312_().getName()}));
            PacketHandler.sendToServer(new QuestionCreatePactC2SPacket(this.player.get().m_105312_().getId(), this.pact.get()));
            cap.createPactCreationRequest(this.player.get().m_105312_().getId(), this.pact.get());
        }).m_253046_(40, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.create = builder.m_252794_(xOffset + 128, yOffset + 9 + 66).m_253136_();
        this.addRenderableWidget(this.create);
        Button.Builder builder2 = Button.m_253074_((Component)Component.m_237115_((String)String.format("gui.%s.pact.remove", "jujutsu_kaisen")), pButton -> {
            if (this.player == null || this.pact == null) {
                return;
            }
            ISorcererData cap = (ISorcererData)this.minecraft.f_91074_.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            this.minecraft.f_91074_.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.pact_request_remove", "jujutsu_kaisen"), (Object[])new Object[]{this.player.get().m_105312_().getName()}));
            PacketHandler.sendToServer(new QuestionRemovePactC2SPacket(this.player.get().m_105312_().getId(), this.pact.get()));
            cap.createPactRemovalRequest(this.player.get().m_105312_().getId(), this.pact.get());
        }).m_253046_(40, 20);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.remove = builder2.m_252794_(xOffset + 176, yOffset + 9 + 66).m_253136_();
        this.addRenderableWidget(this.remove);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.description = new MultiLineTextWidget(xOffset + 128, yOffset + 9 + 1, (Component)Component.m_237119_(), this.minecraft.f_91062_).m_269098_(87);
        this.addRenderableWidget(this.description);
    }
}

