/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.client.MixinData;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class ProjectionParticle<T extends ProjectionParticleOptions>
extends TextureSheetParticle {
    private final int entityId;
    private final float yaw;
    @Nullable
    private LivingEntity entity;
    private float position;
    private float speed;

    protected ProjectionParticle(ClientLevel pLevel, double pX, double pY, double pZ, T options) {
        super(pLevel, pX, pY, pZ);
        this.f_107230_ = 0.5f;
        this.entityId = ((ProjectionParticleOptions)options).entityId();
        this.yaw = ((ProjectionParticleOptions)options).yaw();
    }

    public void m_5989_() {
        if (this.entity == null) {
            Entity entity = this.f_107208_.m_6815_(this.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            this.entity = living;
            this.position = living.f_267362_.m_267756_();
            this.speed = living.f_267362_.m_267731_();
        } else if (!JJKAbilities.isChanneling(this.entity, (Ability)JJKAbilities.PROJECTION_SORCERY.get())) {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        if (this.entity != null) {
            PoseStack stack = new PoseStack();
            float yRot = this.entity.m_146908_();
            float yRotO = this.entity.f_19859_;
            float yHeadRot = this.entity.f_20885_;
            float yHeadRotO = this.entity.f_20886_;
            float yBodyRot = this.entity.f_20883_;
            float yBodyRotO = this.entity.f_20884_;
            boolean invisible = this.entity.m_20145_();
            this.entity.m_6842_(false);
            MixinData.isCustomWalkAnimation = true;
            MixinData.walkAnimationPosition = this.position;
            MixinData.walkAnimationSpeed = this.speed;
            this.entity.m_146922_(this.yaw);
            this.entity.f_19859_ = this.yaw;
            this.entity.f_20885_ = this.yaw;
            this.entity.f_20886_ = this.yaw;
            this.entity.f_20883_ = this.yaw;
            this.entity.f_20884_ = this.yaw;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_107230_);
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            EntityRenderer renderer = manager.m_114382_((Entity)this.entity);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            Vec3 offset = renderer.m_7860_((Entity)this.entity, pPartialTicks);
            stack.m_85837_(this.f_107212_ - pRenderInfo.m_90583_().f_82479_ + offset.f_82479_, this.f_107213_ - pRenderInfo.m_90583_().f_82480_ + offset.f_82480_, this.f_107214_ - pRenderInfo.m_90583_().f_82481_ + offset.f_82481_);
            renderer.m_7392_((Entity)this.entity, 0.0f, pPartialTicks, stack, (MultiBufferSource)buffer, manager.m_114394_((Entity)this.entity, pPartialTicks));
            buffer.m_6299_(RenderType.m_110466_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entity.f_20884_ = yBodyRotO;
            this.entity.f_20883_ = yBodyRot;
            this.entity.f_20886_ = yHeadRotO;
            this.entity.f_20885_ = yHeadRot;
            this.entity.f_19859_ = yRotO;
            this.entity.m_146922_(yRot);
            this.entity.m_6842_(invisible);
            MixinData.isCustomWalkAnimation = false;
            buffer.m_109911_();
        }
    }

    public record ProjectionParticleOptions(int entityId, float yaw) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<ProjectionParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ProjectionParticleOptions>(){

            @NotNull
            public ProjectionParticleOptions fromCommand(@NotNull ParticleType<ProjectionParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                return new ProjectionParticleOptions(reader.readInt(), reader.readFloat());
            }

            @NotNull
            public ProjectionParticleOptions fromNetwork(@NotNull ParticleType<ProjectionParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new ProjectionParticleOptions(buf.readInt(), buf.readFloat());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.PROJECTION.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeInt(this.entityId);
            buf.writeFloat(this.yaw);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %f %f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.entityId, Float.valueOf(this.yaw));
        }
    }

    public static class Provider
    implements ParticleProvider<ProjectionParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public Particle createParticle(@NotNull ProjectionParticleOptions pType, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ProjectionParticle<ProjectionParticleOptions>(pLevel, pX, pY, pZ, pType);
        }
    }
}

