/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.entity.effect.JacobsLadderEntity;

public class JacobsLadderRenderer
extends EntityRenderer<JacobsLadderEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("jujutsu_kaisen", "textures/entity/sky_strike.png");
    private static final float TEXTURE_WIDTH = 208.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float BEAM_MIN_U = 0.84615386f;
    private static final float BEAM_MAX_U = 1.0f;
    private static final float PIXEL_SCALE = 0.0625f;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLIER = 0.7f;
    private static final float RING_RADIUS = 1.6f;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 6;
    private static final int BEAM_FRAME_COUNT = 31;
    private static final float BEAM_DRAW_START_RADIUS = 2.0f;
    private static final float BEAM_DRAW_END_RADIUS = 0.25f;
    private static final float BEAM_STRIKE_RADIUS = 1.0f;

    public JacobsLadderRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    private static void vertex(Matrix4f matrix4f, PoseStack.Pose pose, VertexConsumer consumer, float x, float y, float z, float u, float v, float alpha, int packedLight) {
        consumer.m_252986_(matrix4f, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JacobsLadderEntity pEntity) {
        return TEXTURE;
    }

    public void render(JacobsLadderEntity pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        float maxY = (float)(256.0 - pEntity.m_20186_());
        if (maxY < 0.0f) {
            return;
        }
        boolean isStriking = pEntity.isStriking(pPartialTick);
        pPoseStack.m_85836_();
        float scale = Math.max(1.5f, pEntity.getPower() * 0.2f);
        pPoseStack.m_85841_(scale, scale, scale);
        VertexConsumer consumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        if (isStriking && pEntity.m_6084_()) {
            this.drawStrike(pEntity, maxY, pPartialTick, pPoseStack, consumer, pPackedLight);
        }
        pPoseStack.m_85849_();
    }

    private void drawStrike(JacobsLadderEntity entity, float maxY, float partialTicks, PoseStack poseStack, VertexConsumer builder, int packedLightIn) {
        float opacity;
        float drawTime = entity.getStrikeDrawTime(partialTicks);
        float strikeTime = entity.getStrikeDamageTime(partialTicks);
        boolean drawing = entity.isStrikeDrawing(partialTicks);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity, poseStack, builder, packedLightIn);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90590_()));
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY, poseStack, builder, packedLightIn);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity, PoseStack poseStack, VertexConsumer consumer, int packedLight) {
        this.drawRing(drawing, drawTime, strikeTime, opacity, poseStack, consumer, packedLight, 1.6f);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity, PoseStack poseStack, VertexConsumer consumer, int packedLight, float radius) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 7.0f);
        if (frame > 6) {
            frame = 6;
        }
        float minU = (float)(frame * 16) / 208.0f;
        float maxU = minU + 0.07692308f;
        float minV = drawing ? 0.0f : 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.0625f * radius * (float)(frame % 2);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        JacobsLadderRenderer.vertex(matrix4f, pose, consumer, -radius + offset, 0.0f, -radius + offset, minU, minV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, consumer, -radius + offset, 0.0f, radius + offset, minU, maxV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, consumer, radius + offset, 0.0f, radius + offset, maxU, maxV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, consumer, radius + offset, 0.0f, -radius + offset, maxU, minV, opacity, packedLight);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, float maxY, PoseStack poseStack, VertexConsumer builder, int packedLight) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        float radius = 1.0f;
        if (drawing) {
            radius = -1.75f * drawTime + 2.0f;
        }
        float minV = (float)frame / 32.0f;
        float maxV = ((float)frame + 1.0f) / 32.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        JacobsLadderRenderer.vertex(matrix4f, pose, builder, -radius, 0.0f, 0.0f, 0.84615386f, minV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, builder, -radius, maxY, 0.0f, 0.84615386f, maxV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, builder, radius, maxY, 0.0f, 1.0f, maxV, opacity, packedLight);
        JacobsLadderRenderer.vertex(matrix4f, pose, builder, radius, 0.0f, 0.0f, 1.0f, minV, opacity, packedLight);
    }
}

