/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.slice;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import radon.jujutsu_kaisen.client.slice.Collider;
import radon.jujutsu_kaisen.client.slice.GJK;
import radon.jujutsu_kaisen.client.slice.RigidBody;
import radon.jujutsu_kaisen.util.MathUtil;

public class Contact {
    public RigidBody bodyA;
    public RigidBody bodyB;
    public Collider a;
    public Collider b;
    public Vec3 localA;
    public Vec3 localB;
    public Vec3 globalA;
    public Vec3 globalB;
    public Vec3 normal;
    public float depth;
    public Vec3 tangent;
    public Vec3 bitangent;
    public Vec3 rA;
    public Vec3 rB;
    public Jacobian normalContact;
    public Jacobian tangentContact;
    public Jacobian bitangentContact;

    public Contact(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, GJK.GJKInfo info) {
        this.a = a;
        this.b = b;
        this.bodyA = bodyA == null ? RigidBody.DUMMY : bodyA;
        this.bodyB = bodyB == null ? RigidBody.DUMMY : bodyB;
        this.localA = this.bodyA.globalToLocalPos(info.contactPointA);
        this.localB = this.bodyB.globalToLocalPos(info.contactPointB);
        this.globalA = info.contactPointA;
        this.globalB = info.contactPointB;
        this.normal = info.normal;
        this.depth = info.depth;
        this.tangent = Math.abs(this.normal.f_82479_) >= 0.57735 ? new Vec3(this.normal.f_82480_, -this.normal.f_82479_, 0.0).m_82541_() : new Vec3(0.0, this.normal.f_82481_, -this.normal.f_82480_).m_82541_();
        this.bitangent = this.normal.m_82537_(this.tangent);
        this.normalContact = new Jacobian(false);
        this.tangentContact = new Jacobian(true);
        this.bitangentContact = new Jacobian(true);
    }

    public void init(float dt) {
        this.rA = this.globalA.m_82546_(this.bodyA == RigidBody.DUMMY ? this.a.localCentroid : this.bodyA.globalCentroid);
        this.rB = this.globalB.m_82546_(this.bodyB == RigidBody.DUMMY ? this.b.localCentroid : this.bodyB.globalCentroid);
        this.normalContact.init(this, this.normal, dt);
        this.tangentContact.init(this, this.tangent, dt);
        this.bitangentContact.init(this, this.bitangent, dt);
    }

    public void solve() {
        this.normalContact.solve(this);
        this.tangentContact.solve(this);
        this.bitangentContact.solve(this);
    }

    public static class Jacobian {
        private final boolean tangent;
        private Vec3 jVa;
        private Vec3 jWa;
        private Vec3 jVb;
        private Vec3 jWb;
        private float bias;
        private double effectiveMass;
        private double totalLambda;

        public Jacobian(boolean tangent) {
            this.tangent = tangent;
        }

        public void init(Contact contact, Vec3 dir, float dt) {
            this.jVa = dir.m_82548_();
            this.jWa = contact.rA.m_82537_(dir).m_82548_();
            this.jVb = dir;
            this.jWb = contact.rB.m_82537_(dir);
            if (!this.tangent) {
                float closingVel = (float)contact.bodyA.linearVelocity.m_82548_().m_82546_(contact.bodyA.angularVelocity.m_82537_(contact.rA)).m_82549_(contact.bodyB.linearVelocity).m_82549_(contact.bodyB.angularVelocity.m_82537_(contact.rB)).m_82526_(contact.normal);
                float restitution = contact.bodyA.restitution * contact.bodyB.restitution;
                float beta = 0.2f;
                float dslop = 5.0E-4f;
                float rslop = 0.5f;
                this.bias = -(beta / dt) * Math.max(contact.depth - dslop, 0.0f) + Math.max(restitution * closingVel - rslop, 0.0f);
            }
            this.effectiveMass = (double)contact.bodyA.invMass + this.jWa.m_82526_(MathUtil.transform(this.jWa, contact.bodyA.invGlobalInertiaTensor)) + (double)contact.bodyB.invMass + this.jWb.m_82526_(MathUtil.transform(this.jWb, contact.bodyB.invGlobalInertiaTensor));
            this.effectiveMass = 1.0 / this.effectiveMass;
            this.totalLambda = 0.0;
        }

        public void solve(Contact contact) {
            double jv = this.jVa.m_82526_(contact.bodyA.linearVelocity) + this.jWa.m_82526_(contact.bodyA.angularVelocity) + this.jVb.m_82526_(contact.bodyB.linearVelocity) + this.jWb.m_82526_(contact.bodyB.angularVelocity);
            double lambda = this.effectiveMass * -(jv + (double)this.bias);
            double oldTotalLambda = this.totalLambda;
            if (this.tangent) {
                float friction = contact.bodyA.friction * contact.bodyB.friction;
                double maxFriction = (double)friction * contact.normalContact.totalLambda;
                this.totalLambda = Mth.m_14008_((double)(this.totalLambda + lambda), (double)(-maxFriction), (double)maxFriction);
            } else {
                this.totalLambda = Math.max(0.0, oldTotalLambda + lambda);
            }
            lambda = this.totalLambda - oldTotalLambda;
            contact.bodyA.addLinearVelocity(this.jVa.m_82490_((double)contact.bodyA.invMass * lambda));
            contact.bodyA.addAngularVelocity(MathUtil.transform(this.jWa, contact.bodyA.invGlobalInertiaTensor).m_82490_(lambda));
            contact.bodyB.addLinearVelocity(this.jVb.m_82490_((double)contact.bodyB.invMass * lambda));
            contact.bodyB.addAngularVelocity(MathUtil.transform(this.jWb, contact.bodyB.invGlobalInertiaTensor).m_82490_(lambda));
        }
    }
}

