/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;

public class AbilityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").requires(player -> player.m_6761_(2))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"ability", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            JJKAbilities.ABILITIES.getEntries().forEach(entry -> builder.suggest(entry.getId().toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"ability");
            return AbilityCommand.unlockAbility(player, id);
        }))))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"ability", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            JJKAbilities.ABILITIES.getEntries().forEach(entry -> builder.suggest(entry.getId().toString()));
            return builder.buildFuture();
        }).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"ability");
            return AbilityCommand.lockAbility(player, id);
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trait").requires(player -> player.m_6761_(2))).redirect((CommandNode)node));
    }

    public static int unlockAbility(ServerPlayer player, ResourceLocation id) {
        Optional<Ability> ability = JJKAbilities.ABILITIES.getEntries().stream().filter(e -> e.getId().equals((Object)id)).map(e -> (Ability)e.get()).findFirst();
        if (ability.isEmpty()) {
            return 0;
        }
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.unlock(ability.get());
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
        return 1;
    }

    public static int lockAbility(ServerPlayer player, ResourceLocation id) {
        Optional<Ability> ability = JJKAbilities.ABILITIES.getEntries().stream().filter(e -> e.getId().equals((Object)id)).map(e -> (Ability)e.get()).findFirst();
        if (ability.isEmpty()) {
            return 0;
        }
        ISorcererData cap = (ISorcererData)player.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        cap.lock(ability.get());
        PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(cap.serializeNBT()), player);
        return 1;
    }
}

