/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.base.IJumpInputListener;
import radon.jujutsu_kaisen.entity.curse.base.CursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BirdCurseEntity
extends CursedSpirit
implements PlayerRideable,
IJumpInputListener {
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("move.fly");
    private static final RawAnimation SWING = RawAnimation.begin().thenPlay("attack.swing");
    private boolean jump;

    public BirdCurseEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    @Override
    protected boolean isCustom() {
        return false;
    }

    @Override
    protected boolean canFly() {
        return true;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    protected float m_274460_() {
        return this.m_5448_() == null || this.m_20160_() ? 0.15f : 0.05f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.createAttributes().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 20.0).m_22266_(Attributes.f_22280_);
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.GRADE_3.getRequiredExperience() * 0.5f;
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    private PlayState flyPredicate(AnimationState<BirdCurseEntity> animationState) {
        if (!this.m_20096_() || animationState.isMoving()) {
            return animationState.setAndContinue(FLY);
        }
        return PlayState.STOP;
    }

    private PlayState swingPredicate(AnimationState<BirdCurseEntity> animationState) {
        if (this.f_20911_) {
            return animationState.setAndContinue(SWING);
        }
        animationState.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fly", 5, this::flyPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Swing", this::swingPredicate)});
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && this.m_21824_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.m_20096_()) {
            return Vec3.f_82478_;
        }
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    public boolean m_20068_() {
        return !this.m_20160_() && super.m_20068_();
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        Vec3 movement = this.m_20184_();
        if (this.jump) {
            this.m_20256_(movement.m_82520_(0.0, (double)this.m_274460_(), 0.0));
        }
    }

    @Override
    public void setJump(boolean jump) {
        this.jump = jump;
    }

    static enum Flight {
        ASCEND,
        SPRINT,
        NORMAL;

    }
}

