/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.entity.JJKEntities;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableCurseGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableSorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.curse.base.PackCursedSpirit;
import radon.jujutsu_kaisen.entity.sorcerer.base.SorcererEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FelineCurseEntity
extends PackCursedSpirit
implements PlayerRideable {
    private static final EntityDataAccessor<Integer> DATA_LEAP = SynchedEntityData.m_135353_(FelineCurseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    private static final RawAnimation LEAP = RawAnimation.begin().thenPlay("attack.leap");
    private static final int LEAP_DURATION = 10;
    private static final int LEAP_TICK_INTERVAL = 2;
    private int leapTickCounter = 0;

    public FelineCurseEntity(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
    }

    public FelineCurseEntity(FelineCurseEntity leader) {
        this((EntityType<? extends TamableAnimal>)((EntityType)JJKEntities.FELINE_CURSE.get()), leader.m_9236_());
        this.setLeader(leader);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && !this.m_20160_()) {
            if (pPlayer.m_20329_((Entity)this)) {
                pPlayer.m_146922_(this.m_146908_());
                pPlayer.m_146926_(this.m_146909_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity living;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    private Vec2 getRiddenRotation(LivingEntity pEntity) {
        return new Vec2(pEntity.m_146909_() * 0.5f, pEntity.m_146908_());
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)this.m_21133_(Attributes.f_22279_) * 1.5f;
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (pPlayer.f_20900_ != 0.0f || pPlayer.f_20902_ != 0.0f) {
            Vec2 vec2 = this.getRiddenRotation((LivingEntity)pPlayer);
            this.m_19915_(vec2.f_82471_, vec2.f_82470_);
            this.f_20885_ = this.f_20886_ = this.m_146908_();
            this.f_20883_ = this.f_20886_;
            this.f_19859_ = this.f_20886_;
        }
        super.m_274498_(pPlayer, pTravelVector);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return SorcererEntity.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        float f = pPlayer.f_20900_ * 0.5f;
        float f1 = pPlayer.f_20902_ <= 0.0f ? pPlayer.f_20902_ * 0.25f : pPlayer.f_20902_;
        return new Vec3((double)f, 0.0, (double)f1);
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public int getMinCount() {
        return 1;
    }

    @Override
    public int getMaxCount() {
        return 4;
    }

    @Override
    protected PackCursedSpirit spawn() {
        return new FelineCurseEntity(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_LEAP, (Object)0);
    }

    protected void m_8099_() {
        int goal = 1;
        int target = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal((PathfinderMob)this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new CustomLeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(goal++, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, true));
        this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, true));
        if (this.targetsSorcerers()) {
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableSorcererGoal((Mob)this, true));
        }
        if (this.targetsCurses()) {
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableCurseGoal((Mob)this, true));
        }
    }

    @Override
    protected boolean isCustom() {
        return true;
    }

    @Override
    public boolean hasMeleeAttack() {
        return true;
    }

    @Override
    public boolean hasArms() {
        return false;
    }

    @Override
    public boolean canJump() {
        return false;
    }

    @Override
    public boolean canChant() {
        return false;
    }

    @Override
    public float getExperience() {
        return SorcererGrade.GRADE_3.getRequiredExperience();
    }

    @Override
    @Nullable
    public CursedTechnique getTechnique() {
        return null;
    }

    private PlayState movementPredicate(AnimationState<FelineCurseEntity> state) {
        if ((Integer)this.f_19804_.m_135370_(DATA_LEAP) > 0) {
            return state.setAndContinue(LEAP);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.m_20142_() ? RUN : WALK);
        }
        return state.setAndContinue(IDLE);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", this::movementPredicate)});
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.leapTickCounter++ >= 2) {
            int leap = (Integer)this.f_19804_.m_135370_(DATA_LEAP);
            if (leap > 0) {
                this.f_19804_.m_135381_(DATA_LEAP, (Object)(leap - 1));
            }
            this.leapTickCounter = 0;
        }
    }

    private class CustomLeapAtTargetGoal
    extends LeapAtTargetGoal {
        public CustomLeapAtTargetGoal(Mob pMob, float pYd) {
            super(pMob, pYd);
        }

        public void m_8056_() {
            super.m_8056_();
            FelineCurseEntity.this.f_19804_.m_135381_(DATA_LEAP, (Object)10);
        }
    }
}

