/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity.curse.base;

import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererGrade;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.entity.ai.goal.BetterFollowOwnerGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableCurseGoal;
import radon.jujutsu_kaisen.entity.ai.goal.NearestAttackableSorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.SorcererGoal;
import radon.jujutsu_kaisen.entity.ai.goal.WaterWalkingFloatGoal;
import radon.jujutsu_kaisen.entity.base.ICommandable;
import radon.jujutsu_kaisen.entity.base.ISorcerer;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;
import radon.jujutsu_kaisen.util.SorcererUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class CursedSpirit
extends TamableAnimal
implements GeoEntity,
ISorcerer,
ICommandable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    protected CursedSpirit(EntityType<? extends TamableAnimal> pType, Level pLevel) {
        super(pType, pLevel);
        this.m_7105_(false);
    }

    private boolean isInVillage() {
        HolderSet.Named structures = (HolderSet.Named)this.m_9236_().m_9598_().m_175515_(Registries.f_256944_).m_203431_(StructureTags.f_215889_).orElseThrow();
        boolean success = false;
        for (Holder holder : structures) {
            if (!((ServerLevel)this.m_9236_()).m_215010_().m_220524_(this.m_20183_(), (Structure)holder.get()).m_73603_()) continue;
            success = true;
            break;
        }
        return success;
    }

    private boolean isInFortress() {
        Structure structure = (Structure)this.m_9236_().m_9598_().m_175515_(Registries.f_256944_).m_6246_(BuiltinStructures.f_209859_);
        if (structure == null) {
            return false;
        }
        return ((ServerLevel)this.m_9236_()).m_215010_().m_220524_(this.m_20183_(), structure).m_73603_();
    }

    public boolean m_5545_(@NotNull LevelAccessor pLevel, @NotNull MobSpawnType pSpawnReason) {
        if (pSpawnReason == MobSpawnType.NATURAL || pSpawnReason == MobSpawnType.CHUNK_GENERATION) {
            if (this.isInVillage()) {
                if ((Integer)ConfigHolder.SERVER.curseVillageSpawnRate.get() == 0) {
                    return false;
                }
                if (this.f_19796_.m_188503_(Math.max((int)1, (int)Mth.m_14143_((float)((float)((Integer)ConfigHolder.SERVER.curseVillageSpawnRate.get()).intValue() * SorcererUtil.getPower(this.getExperience()) * (this.m_9236_().m_46462_() ? 2.0f : 1.0f))))) != 0) {
                    return false;
                }
                if (this.getGrade().ordinal() == SorcererGrade.SPECIAL_GRADE.ordinal()) {
                    return false;
                }
            } else if (!this.isInFortress()) {
                return false;
            }
            if (this.getGrade().ordinal() < SorcererGrade.SPECIAL_GRADE.ordinal() ? !this.isInVillage() && !this.isInFortress() : !this.isInFortress()) {
                return false;
            }
        }
        if (this.getGrade().ordinal() >= SorcererGrade.GRADE_1.ordinal() && !pLevel.m_45976_(this.getClass(), AABB.m_165882_((Vec3)this.m_20182_(), (double)128.0, (double)64.0, (double)128.0)).isEmpty()) {
            return false;
        }
        if (!pLevel.m_45976_(CursedSpirit.class, AABB.m_165882_((Vec3)this.m_20182_(), (double)16.0, (double)8.0, (double)16.0)).isEmpty()) {
            return false;
        }
        return super.m_5545_(pLevel, pSpawnReason);
    }

    public boolean m_21532_() {
        return this.getGrade().ordinal() > SorcererGrade.GRADE_1.ordinal();
    }

    protected abstract boolean isCustom();

    protected boolean canFly() {
        return false;
    }

    protected boolean targetsCurses() {
        return false;
    }

    protected boolean targetsSorcerers() {
        return true;
    }

    private void createGoals() {
        int target = 1;
        int goal = 1;
        this.f_21345_.m_25352_(goal++, (Goal)new WaterWalkingFloatGoal((PathfinderMob)this));
        if (this.hasMeleeAttack()) {
            this.f_21345_.m_25352_(goal++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.9, true));
        }
        this.f_21345_.m_25352_(goal++, (Goal)new SorcererGoal((PathfinderMob)this));
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(goal++, (Goal)new BetterFollowOwnerGoal(this, 1.0, 25.0f, 10.0f, this.canFly()));
            this.f_21346_.m_25352_(target++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(target, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        } else {
            this.f_21346_.m_25352_(target++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
            this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
            if (this.targetsSorcerers()) {
                this.f_21346_.m_25352_(target++, (Goal)new NearestAttackableSorcererGoal((Mob)this, true));
            }
            if (this.targetsCurses()) {
                this.f_21346_.m_25352_(target, (Goal)new NearestAttackableCurseGoal((Mob)this, true));
            }
        }
        this.f_21345_.m_25352_(goal, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        return (!this.m_21824_() || pTarget != this.m_269323_()) && super.m_6779_(pTarget);
    }

    protected void m_6475_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        LivingEntity attacker;
        Entity entity;
        super.m_6475_(pDamageSource, pDamageAmount);
        if (!this.m_21824_() && (entity = pDamageSource.m_7639_()) instanceof LivingEntity && this.m_6779_(attacker = (LivingEntity)entity) && attacker != this) {
            this.m_6710_(attacker);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity m_269323_() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        LivingEntity target = this.m_5448_();
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, pLevel);
        navigation.m_26477_(false);
        navigation.m_7008_(false);
        navigation.m_148214_(true);
        return navigation;
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity passenger = this.m_6688_();
        if (this.m_5448_() != null) {
            this.f_21342_.m_6849_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_(), (double)1.1f);
        }
        if (passenger != null) {
            this.m_6858_(new Vec3((double)passenger.f_20900_, (double)passenger.f_20901_, (double)passenger.f_20902_).m_82556_() > 0.01);
        } else {
            this.m_6858_(this.m_20184_().m_82556_() > 0.01 && this.f_21342_.m_24999_() > 1.0);
        }
    }

    public void onAddedToWorld() {
        LivingEntity livingEntity;
        super.onAddedToWorld();
        if (!this.isCustom()) {
            this.createGoals();
        }
        this.getCapability(SorcererDataHandler.INSTANCE).ifPresent(this::init);
        if (this.canChangeTarget() && (livingEntity = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237115_((String)String.format("chat.%s.set_target_info", "jujutsu_kaisen")), false), player);
        }
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21824_()) {
            LivingEntity target = this.m_5448_();
            this.m_21839_(target != null && !target.m_213877_() && target.m_6084_());
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public JujutsuType getJujutsuType() {
        return JujutsuType.CURSE;
    }

    @Override
    public boolean canChangeTarget() {
        return this.m_21824_();
    }

    @Override
    public void changeTarget(LivingEntity target) {
        this.m_6710_(target);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.m_269323_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }
}

