/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.mixin.client;

import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import radon.jujutsu_kaisen.client.FakeEntityRenderer;
import radon.jujutsu_kaisen.client.JJKRenderers;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.JJKPartEntity;
import radon.jujutsu_kaisen.entity.effect.ProjectionFrameEntity;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin<E extends Entity> {
    @ModifyVariable(method={"onResourceManagerReload"}, at=@At(value="TAIL"))
    public EntityRendererProvider.Context onResourceManagerReload(EntityRendererProvider.Context pContext) {
        JJKRenderers.bake(pContext);
        return pContext;
    }

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRenderer(Entity pEntity, CallbackInfoReturnable<EntityRenderer<?>> cir) {
        if (pEntity instanceof JJKPartEntity) {
            JJKPartEntity part = (JJKPartEntity)pEntity;
            cir.setReturnValue(JJKRenderers.lookup(part.getRenderer()));
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    public void shouldRender(E pEntity, Frustum pFrustum, double pCamX, double pCamY, double pCamZ, CallbackInfoReturnable<Boolean> cir) {
        if (!FakeEntityRenderer.isFakeRender) {
            LivingEntity living;
            if (pEntity instanceof LivingEntity && (living = (LivingEntity)pEntity).m_21023_((MobEffect)JJKEffects.INVISIBILITY.get())) {
                cir.setReturnValue((Object)false);
                return;
            }
            for (ProjectionFrameEntity frame : pEntity.m_9236_().m_45976_(ProjectionFrameEntity.class, AABB.m_165882_((Vec3)pEntity.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (frame.getVictim() != pEntity) continue;
                cir.setReturnValue((Object)true);
            }
        }
    }
}

