/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.network.packet.c2s;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.Pact;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;

public class QuestionRemovePactC2SPacket {
    private final UUID identifier;
    private final Pact pact;

    public QuestionRemovePactC2SPacket(UUID identifier, Pact pact) {
        this.identifier = identifier;
        this.pact = pact;
    }

    public QuestionRemovePactC2SPacket(FriendlyByteBuf buf) {
        this(buf.m_130259_(), (Pact)buf.m_130066_(Pact.class));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.identifier);
        buf.m_130068_((Enum)this.pact);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            assert (sender != null);
            ISorcererData cap = (ISorcererData)sender.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            cap.createPactRemovalRequest(this.identifier, this.pact);
            Player player = sender.m_284548_().m_46003_(this.identifier);
            if (player == sender) {
                return;
            }
            if (player != null) {
                MutableComponent accept = Component.m_237115_((String)String.format("chat.%s.pact_question_accept", "jujutsu_kaisen")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/pactremovalaccept %s %s", sender.m_7755_().getString(), this.pact.name()))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)String.format("chat.%s.pact_question_remove", "jujutsu_kaisen")))));
                MutableComponent decline = Component.m_237115_((String)String.format("chat.%s.pact_question_decline", "jujutsu_kaisen")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/pactremovaldecline %s %s", sender.m_7755_().getString(), this.pact.name()))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)String.format("chat.%s.pact_question_remove", "jujutsu_kaisen")))));
                MutableComponent message = Component.m_237110_((String)String.format("chat.%s.pact_question_remove", "jujutsu_kaisen"), (Object[])new Object[]{accept, decline, this.pact.getName().getString().toLowerCase(), sender.m_7755_()});
                player.m_213846_((Component)message);
            }
        });
        ctx.setPacketHandled(true);
    }
}

