/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.body_swap;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedEnergyNature;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class BodySteal
extends Ability
implements Ability.IToggled {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
        } else if (((Boolean)ConfigHolder.SERVER.playerBodySteal.get()).booleanValue()) {
            return false;
        }
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.SORCERER && (double)cap.getExperience() >= (Double)ConfigHolder.SERVER.minimumBodyStealEXP.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canSteal(LivingEntity owner, LivingEntity target) {
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (target instanceof Player) {
            Player player = (Player)target;
        } else if ((Boolean)ConfigHolder.SERVER.playerBodySteal.get() != false) return false;
        if (targetCap.getType() != JujutsuType.SORCERER) return false;
        if (!target.m_21224_()) return false;
        if (!((double)targetCap.getExperience() >= (Double)ConfigHolder.SERVER.minimumBodyStealEXP.get())) return false;
        return true;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 0.0f;
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    private static void check(LivingEntity victim, DamageSource source) {
        if (victim instanceof Player) {
            Player player = (Player)victim;
        } else if (((Boolean)ConfigHolder.SERVER.playerBodySteal.get()).booleanValue()) {
            return;
        }
        if (!victim.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return;
        }
        if (!HelperMethods.isMelee(source)) {
            return;
        }
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (!BodySteal.canSteal(attacker, victim)) {
            return;
        }
        if (!JJKAbilities.hasToggled(attacker, (Ability)JJKAbilities.BODY_STEAL.get())) {
            return;
        }
        attacker.m_21011_(InteractionHand.MAIN_HAND, true);
        ISorcererData ownerCap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        ISorcererData targetCap = (ISorcererData)victim.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if ((double)targetCap.getExperience() <= (Double)ConfigHolder.SERVER.minimumBodyStealEXP.get()) {
            return;
        }
        CursedTechnique current = ownerCap.getTechnique();
        CursedTechnique steal = targetCap.getTechnique();
        CursedEnergyNature nature = targetCap.getNature();
        if (current == null) {
            return;
        }
        if (current == steal || steal == CursedTechnique.MIMICRY) {
            return;
        }
        ownerCap.addStolen(steal);
        ownerCap.setNature(nature);
        if (((Boolean)ConfigHolder.SERVER.bodyStealEXPReset.get()).booleanValue()) {
            targetCap.setExperience(0.0f);
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer servOwner = (ServerPlayer)attacker;
            attacker.m_213846_((Component)Component.m_237110_((String)String.format("chat.%s.bodysteal", "jujutsu_kaisen"), (Object[])new Object[]{victim.m_7755_()}));
            SyncSorcererDataS2CPacket packet = new SyncSorcererDataS2CPacket(ownerCap.serializeNBT());
            PacketHandler.sendToClient(packet, servOwner);
        }
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BodyStealForgeEvents {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            BodySteal.check(event.getEntity(), event.getSource());
        }
    }
}

