/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_flames;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.util.HelperMethods;

public class DisasterFlames
extends Ability {
    private static final double AOE_RANGE = 6.0;
    private static final float DAMAGE = 19.0f;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(5) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    private void spawnParticles(Entity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f);
        double z = entity.m_20189_();
        for (int i = 0; i < 32; ++i) {
            double scale = HelperMethods.RANDOM.m_188500_() * 0.5 + 0.5;
            Vec3 speed = new Vec3(HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_(), HelperMethods.RANDOM.m_188583_()).m_82541_().m_82490_(scale);
            double offsetX = x + speed.f_82479_;
            double offsetY = y + speed.f_82480_;
            double offsetZ = z + speed.f_82481_;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, offsetX, offsetY, offsetZ, 0, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0);
        }
    }

    private List<Entity> getTargets(LivingEntity owner) {
        List entities = owner.m_9236_().m_45933_((Entity)owner, owner.m_20191_().m_82400_(6.0));
        entities.removeIf(entity -> {
            LivingEntity living;
            return entity instanceof LivingEntity && !owner.m_6779_(living = (LivingEntity)entity);
        });
        return entities;
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        List<Entity> targets = this.getTargets(owner);
        if (targets.isEmpty()) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        for (Entity entity : this.getTargets(owner)) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11874_, SoundSource.MASTER, 1.0f, 1.0f);
            if (!entity.m_6469_((DamageSource)JJKDamageSources.indirectJujutsuAttack((Entity)owner, owner, this), 19.0f * this.getPower(owner))) continue;
            entity.m_20254_(5);
            this.spawnParticles(entity);
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.FIRE;
    }
}

