/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_flames;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class Flamethrower
extends Ability
implements Ability.IChannelened,
Ability.IDurationable {
    private static final float DAMAGE = 13.0f;
    private static final double RANGE = 9.0;

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null || !owner.m_142582_((Entity)target)) {
            return false;
        }
        if (JJKAbilities.isChanneling((LivingEntity)owner, this)) {
            return HelperMethods.RANDOM.m_188503_(2) != 0;
        }
        return HelperMethods.RANDOM.m_188503_(3) == 0 && (double)owner.m_20270_((Entity)target) <= 9.0;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Level level = owner.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (int i = 0; i < 96; ++i) {
                double theta = HelperMethods.RANDOM.m_188500_() * 2.0 * Math.PI;
                double phi = HelperMethods.RANDOM.m_188500_() * Math.PI;
                double r = HelperMethods.RANDOM.m_188500_() * 4.0;
                double x = r * Math.sin(phi) * Math.cos(theta);
                double y = r * Math.sin(phi) * Math.sin(theta);
                double z = r * Math.cos(phi);
                Vec3 start = owner.m_146892_();
                Vec3 end = start.m_82549_(look.m_82490_(18.0)).m_82520_(x, y, z);
                Vec3 speed = start.m_82546_(end).m_82490_(0.08333333333333333).m_82548_();
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123744_, start.f_82479_, start.f_82480_, start.f_82481_, 0, speed.f_82479_, speed.f_82480_, speed.f_82481_, 1.0);
            }
            AABB bounds = AABB.m_165882_((Vec3)owner.m_146892_(), (double)1.0, (double)1.0, (double)1.0).m_82369_(look.m_82490_(9.0)).m_82400_(1.0);
            for (Entity entity2 : owner.m_9236_().m_6443_(LivingEntity.class, bounds, entity -> entity != owner && entity.m_142582_((Entity)owner))) {
                if (!entity2.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), 13.0f * this.getPower(owner))) continue;
                entity2.m_20254_(5);
            }
        }
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 5.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    public Ability.Classification getClassification() {
        return Ability.Classification.FIRE;
    }
}

