/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.disaster_plants;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.CursedTechnique;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.projectile.CursedBudProjectile;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class CursedBud
extends Ability {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        return HelperMethods.RANDOM.m_188503_(2) == 0 && target != null && owner.m_142582_((Entity)target);
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        CursedBudProjectile bud = new CursedBudProjectile(owner, this.getPower(owner));
        Vec3 look = RotationUtil.getTargetAdjustedLookAngle((Entity)owner);
        Vec3 spawn = new Vec3(owner.m_20185_(), owner.m_20188_() - (double)(bud.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(look);
        bud.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, RotationUtil.getTargetAdjustedYRot((Entity)owner), RotationUtil.getTargetAdjustedXRot((Entity)owner));
        owner.m_9236_().m_7967_((Entity)bud);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 50.0f;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class CursedBudForgeEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            DamageSource source = event.getSource();
            Entity entity = source.m_7639_();
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)entity;
            if (attacker.m_9236_().f_46443_) {
                return;
            }
            LivingEntity victim = event.getEntity();
            if (!HelperMethods.isMelee(source)) {
                return;
            }
            if (!attacker.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return;
            }
            ISorcererData cap = (ISorcererData)attacker.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasTechnique(CursedTechnique.DISASTER_PLANTS)) {
                return;
            }
            for (CursedBudProjectile bud : victim.m_9236_().m_45976_(CursedBudProjectile.class, AABB.m_165882_((Vec3)victim.m_20182_(), (double)8.0, (double)8.0, (double)8.0))) {
                if (bud.m_19749_() != attacker) continue;
                bud.implant(victim);
                return;
            }
        }
    }
}

