/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.limitless;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.ability.base.DomainExpansion;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.ClosedDomainExpansionEntity;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.SyncSorcererDataS2CPacket;
import radon.jujutsu_kaisen.util.HelperMethods;

public class UnlimitedVoid
extends DomainExpansion
implements DomainExpansion.IClosedDomain {
    @Override
    public List<Block> getBlocks() {
        return List.of((Block)JJKBlocks.UNLIMITED_VOID.get());
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        boolean enemyDomain = false;
        DomainExpansionEntity selfDomain = null;
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (domain.getOwner() == owner) {
                selfDomain = domain;
                continue;
            }
            if (domain.getOwner() == owner) continue;
            enemyDomain = true;
        }
        if (enemyDomain) {
            ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            if (!cap.hasToggled(this)) {
                return true;
            }
            if (cap.hasToggled(this)) {
                return false;
            }
        } else if (selfDomain != null && !enemyDomain) {
            if (target != null) {
                return (double)selfDomain.m_20270_((Entity)target) >= 60.0;
            }
            if (target == null) {
                return HelperMethods.RANDOM.m_188503_(15) == 0;
            }
        }
        return target != null && (double)owner.m_20270_((Entity)target) <= 25.0 && owner.m_21223_() / owner.m_21233_() < 0.9f && HelperMethods.RANDOM.m_188503_(4) == 0;
    }

    @Override
    public void onHitEntity(DomainExpansionEntity domain, LivingEntity owner, LivingEntity entity, boolean instant) {
        super.onHitEntity(domain, owner, entity, instant);
        entity.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.UNLIMITED_VOID.get(), Math.round(200.0f * UnlimitedVoid.getStrength(owner, instant)), 0, false, false, false));
        entity.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), Math.round(200.0f * UnlimitedVoid.getStrength(owner, instant)), 0, false, false, false));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, Math.round(200.0f * UnlimitedVoid.getStrength(owner, instant)), 4, false, false, false));
        if (domain.getTime() % 20 == 0 && entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            ISorcererData entityCap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            entityCap.increaseBrainDamage();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PacketHandler.sendToClient(new SyncSorcererDataS2CPacket(entityCap.serializeNBT()), player);
            }
        }
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.DOMAIN;
    }

    @Override
    public void onHitBlock(DomainExpansionEntity domain, LivingEntity owner, BlockPos pos) {
    }

    @Override
    protected DomainExpansionEntity createBarrier(LivingEntity owner) {
        int radius = Math.round(this.getRadius(owner));
        ClosedDomainExpansionEntity domain = new ClosedDomainExpansionEntity(owner, this, radius);
        owner.m_9236_().m_7967_((Entity)domain);
        return domain;
    }
}

