/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.VeilHandler;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.effect.JJKEffects;
import radon.jujutsu_kaisen.entity.base.DomainExpansionEntity;
import radon.jujutsu_kaisen.util.HelperMethods;

public class FallingBlossomEmotion
extends Ability
implements Ability.IToggled {
    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        for (DomainExpansionEntity domain : VeilHandler.getDomains((ServerLevel)owner.m_9236_(), owner.m_20183_())) {
            if (!domain.hasSureHitEffect() || !domain.checkSureHitEffect()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.TOGGLED;
    }

    @Override
    public void run(LivingEntity owner) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        owner.m_7292_(new MobEffectInstance((MobEffect)JJKEffects.STUN.get(), 2, 0, false, false, false));
        for (int i = 0; i < 16; ++i) {
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 1.25f) - owner.m_20154_().m_82490_((double)0.35).f_82481_;
            double speed = (double)(owner.m_20206_() * 0.1f) * HelperMethods.RANDOM.m_188500_();
            level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.FALLING_BLOSSOM_EMOTION, owner.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
        }
        for (Projectile projectile : owner.m_9236_().m_45976_(Projectile.class, owner.m_20191_().m_82400_(1.0))) {
            ISorcererData cap;
            DomainExpansionEntity domain;
            LivingEntity living;
            Entity y = projectile.m_19749_();
            if (!(y instanceof LivingEntity) || !(living = (LivingEntity)y).getCapability(SorcererDataHandler.INSTANCE).isPresent() || (domain = (cap = (ISorcererData)living.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getSummonByClass(DomainExpansionEntity.class)) == null || !domain.isAffected(owner) || projectile.m_19749_() != living) continue;
            projectile.m_146870_();
        }
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 1.0f;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.DOMAIN;
    }

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.CURSED_ENERGY_FLOW.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(3.0f, 5.0f);
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.fallingBlossomEmotionCost.get();
    }

    @Override
    public void onEnabled(LivingEntity owner) {
    }

    @Override
    public void onDisabled(LivingEntity owner) {
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class FallingBlossomEmotionForgeEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            DamageSource damageSource = event.getSource();
            if (!(damageSource instanceof JJKDamageSources.JujutsuDamageSource)) {
                return;
            }
            JJKDamageSources.JujutsuDamageSource source = (JJKDamageSources.JujutsuDamageSource)damageSource;
            LivingEntity victim = event.getEntity();
            if (!JJKAbilities.hasToggled(victim, (Ability)JJKAbilities.FALLING_BLOSSOM_EMOTION.get())) {
                return;
            }
            if (!(source.m_7640_() instanceof DomainExpansionEntity)) {
                return;
            }
            event.setAmount(event.getAmount() * 0.25f);
        }
    }
}

