/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.MenuType;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.client.particle.CursedEnergyParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.config.ConfigHolder;
import radon.jujutsu_kaisen.damage.JJKDamageSources;
import radon.jujutsu_kaisen.util.HelperMethods;
import radon.jujutsu_kaisen.util.RotationUtil;

public class OutputRCT
extends Ability {
    public static final float RANGE = 10.0f;

    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public boolean usesHands() {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (!target.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getType() == JujutsuType.CURSE && this.getTarget((LivingEntity)owner) == target;
    }

    @Override
    public MenuType getMenuType() {
        return MenuType.J2TSU;
    }

    @Override
    @Nullable
    public Ability getParent(LivingEntity owner) {
        return (Ability)JJKAbilities.RCT3.get();
    }

    @Override
    public Vec2 getDisplayCoordinates() {
        return new Vec2(5.0f, 2.0f);
    }

    @Override
    public int getPointsCost() {
        return (Integer)ConfigHolder.SERVER.outputRCTCost.get();
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public boolean canUnlock(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.hasTrait(Trait.RCT_OUTPUT) && super.canUnlock(owner);
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.hasTrait(Trait.RCT_OUTPUT) && super.isDisplayed(owner);
    }

    @Nullable
    private LivingEntity getTarget(LivingEntity owner) {
        LivingEntity target = RotationUtil.getExpandedLookAt((Entity)owner, 10.0);
        LivingEntity result = null;
        if (target != null) {
            result = target;
        }
        return result;
    }

    @Override
    public void run(LivingEntity owner) {
        ISorcererData targetCap;
        owner.m_6674_(InteractionHand.MAIN_HAND);
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            return;
        }
        ISorcererData ownerCap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        for (int i = 0; i < 8; ++i) {
            ownerCap.delayTickEvent(() -> {
                for (int j = 0; j < 8; ++j) {
                    double x = target.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(target.m_20205_() * 1.25f) - target.m_20154_().m_82490_((double)0.35).f_82479_;
                    double y = target.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)target.m_20206_();
                    double z = target.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(target.m_20205_() * 1.25f) - target.m_20154_().m_82490_((double)0.35).f_82481_;
                    double speed = (double)(target.m_20206_() * 0.1f) * HelperMethods.RANDOM.m_188500_();
                    level2.m_8767_((ParticleOptions)new CursedEnergyParticle.CursedEnergyParticleOptions(ParticleColors.RCT, target.m_20205_() * 0.5f, 0.2f, 16), x, y, z, 0, 0.0, speed, 0.0, 1.0);
                }
            }, i * 2);
        }
        float healMult = 1.0f;
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (cap.hasTrait(Trait.RCT_OUTPUT)) {
            healMult *= 9.3f;
        }
        if (cap.getType() == JujutsuType.SHIKIGAMI) {
            healMult *= 8.0f;
        }
        float amount = ((Double)ConfigHolder.SERVER.sorcererHealingAmount.get()).floatValue() * this.getPower(owner) * 1.5f * healMult;
        if (target.getCapability(SorcererDataHandler.INSTANCE).isPresent() && (targetCap = (ISorcererData)target.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).getType() == JujutsuType.CURSE) {
            target.m_6469_((DamageSource)JJKDamageSources.jujutsuAttack(owner, this), amount * 15.0f);
            return;
        }
        target.m_5634_(amount);
    }

    @Override
    public Ability.Status isTriggerable(LivingEntity owner) {
        LivingEntity target = this.getTarget(owner);
        if (target == null) {
            return Ability.Status.FAILURE;
        }
        return super.isTriggerable(owner);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 65.0f;
    }

    @Override
    public int getCooldown() {
        return 80;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return (cap.hasTrait(Trait.RCT_OUTPUT) || cap.getType() == JujutsuType.SHIKIGAMI) && cap.getType() != JujutsuType.CURSE && super.isValid(owner);
    }
}

