/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.ability.mythical_beast_amber;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.client.particle.LightningParticle;
import radon.jujutsu_kaisen.client.particle.ParticleColors;
import radon.jujutsu_kaisen.entity.effect.ElectricBeamEntity;
import radon.jujutsu_kaisen.sound.JJKSounds;
import radon.jujutsu_kaisen.util.HelperMethods;

public class ElectricBeam
extends Ability {
    @Override
    public boolean isScalable(LivingEntity owner) {
        return false;
    }

    @Override
    public boolean shouldTrigger(PathfinderMob owner, @Nullable LivingEntity target) {
        if (target == null) {
            return false;
        }
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        return cap.getTechnique() == null && HelperMethods.RANDOM.m_188503_(5) == 0 && owner.m_142582_((Entity)target) && (double)owner.m_20270_((Entity)target) <= 25.0;
    }

    @Override
    public boolean isTechnique() {
        return false;
    }

    @Override
    public Ability.ActivationType getActivationType(LivingEntity owner) {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public void run(LivingEntity owner) {
        owner.m_6674_(InteractionHand.MAIN_HAND);
        ElectricBeamEntity blast = new ElectricBeamEntity(owner, this.getPower(owner));
        owner.m_9236_().m_7967_((Entity)blast);
        if (owner.m_9236_().f_46443_) {
            return;
        }
        int count = 12 + (int)(owner.m_20205_() * owner.m_20206_()) * 16;
        for (int i = 0; i < count; ++i) {
            double x = owner.m_20185_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f) - owner.m_20154_().m_82490_((double)0.5).f_82479_;
            double y = owner.m_20186_() + HelperMethods.RANDOM.m_188500_() * (double)owner.m_20206_();
            double z = owner.m_20189_() + (HelperMethods.RANDOM.m_188500_() - 0.5) * (double)(owner.m_20205_() * 2.0f) - owner.m_20154_().m_82490_((double)0.5).f_82481_;
            ((ServerLevel)owner.m_9236_()).m_8767_((ParticleOptions)new LightningParticle.LightningParticleOptions(ParticleColors.getCursedEnergyColorBright(owner), 0.2f, 1), x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
        }
        owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)JJKSounds.ELECTRICITY.get(), SoundSource.MASTER, 1.0f, 1.0f);
    }

    @Override
    public float getCost(LivingEntity owner) {
        return 100.0f;
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public boolean isValid(LivingEntity owner) {
        return JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.MYTHICAL_BEAST_AMBER.get()) && super.isValid(owner);
    }

    @Override
    public boolean isDisplayed(LivingEntity owner) {
        return JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.MYTHICAL_BEAST_AMBER.get()) && super.isDisplayed(owner);
    }
}

