/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.block.JJKBlocks;
import radon.jujutsu_kaisen.block.entity.JJKBlockEntities;
import radon.jujutsu_kaisen.block.entity.VeilRodBlockEntity;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.JujutsuType;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.item.veil.modifier.Modifier;
import radon.jujutsu_kaisen.item.veil.modifier.PlayerModifier;

public class VeilBlockEntity
extends BlockEntity {
    private int counter;
    @Nullable
    private BlockPos parent;
    private boolean initialized;
    @Nullable
    private BlockState original;
    private CompoundTag deferred;
    private int size;

    public VeilBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JJKBlockEntities.VEIL.get(), pPos, pBlockState);
    }

    public void destroy() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        BlockState original = this.getOriginal();
        if (original == null || original.m_60795_() || original.m_60734_() == JJKBlocks.DOMAIN_AIR.get()) {
            this.f_58857_.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
        this.f_58857_.m_46597_(pos, original);
    }

    public static boolean isWhitelisted(@Nullable BlockPos parent, Entity entity) {
        Object object;
        if (entity == null || parent == null || !((object = entity.m_9236_().m_7702_(parent)) instanceof VeilRodBlockEntity)) {
            return false;
        }
        VeilRodBlockEntity be = (VeilRodBlockEntity)((Object)object);
        if (entity.m_20148_().equals(be.ownerUUID)) {
            return true;
        }
        if (be.modifiers == null) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (Modifier modifier : be.modifiers) {
                if (modifier.getAction() != Modifier.Action.ALLOW || modifier.getType() != Modifier.Type.PLAYER || !((PlayerModifier)modifier).getName().equals(player.m_5446_().getString())) continue;
                return true;
            }
        }
        for (Modifier modifier : be.modifiers) {
            if (modifier.getAction() != Modifier.Action.ALLOW || modifier.getType() != Modifier.Type.CURSE && modifier.getType() != Modifier.Type.SORCERER) continue;
            if (!entity.getCapability(SorcererDataHandler.INSTANCE).isPresent()) {
                return false;
            }
            ISorcererData cap = (ISorcererData)entity.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
            return cap.getType() == JujutsuType.CURSE && modifier.getType() == Modifier.Type.CURSE || cap.getType() != JujutsuType.CURSE && modifier.getType() == Modifier.Type.SORCERER;
        }
        return false;
    }

    @Nullable
    public BlockState getOriginal() {
        if (this.f_58857_ == null) {
            return this.original;
        }
        if (this.original == null && this.deferred != null) {
            this.original = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)this.deferred);
            this.deferred = null;
            this.m_6596_();
        }
        return this.original;
    }

    public void create(BlockPos parent, int size, BlockState original) {
        this.parent = parent;
        this.size = size;
        if (original.m_60734_() == JJKBlocks.DOMAIN_AIR.get()) {
            original = Blocks.f_50016_.m_49966_();
        }
        this.original = original;
        this.sendUpdates();
    }

    @Nullable
    public BlockPos getParent() {
        return this.parent;
    }

    public static boolean isAllowed(BlockPos pos, Entity entity) {
        return VeilBlockEntity.isWhitelisted(pos, entity);
    }

    public void sendUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6550_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_));
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_).m_60734_());
            this.m_6596_();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("initialized", this.initialized);
        if (this.initialized) {
            if (this.original != null) {
                pTag.m_128365_("original", (Tag)NbtUtils.m_129202_((BlockState)this.original));
            } else {
                pTag.m_128365_("original", (Tag)this.deferred);
            }
        }
        if (this.parent != null) {
            pTag.m_128365_("parent", (Tag)NbtUtils.m_129224_((BlockPos)this.parent));
        }
        pTag.m_128405_("size", this.size);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.initialized = pTag.m_128471_("initialized");
        if (this.initialized) {
            this.deferred = pTag.m_128469_("original");
        }
        if (pTag.m_128441_("parent")) {
            this.parent = NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("parent"));
        }
        this.size = pTag.m_128451_("size");
    }
}

