/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.chant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.ability.AbilityStopEvent;
import radon.jujutsu_kaisen.ability.AbilityTriggerEvent;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.capability.data.sorcerer.Trait;
import radon.jujutsu_kaisen.chant.ChantHandler;
import radon.jujutsu_kaisen.network.PacketHandler;
import radon.jujutsu_kaisen.network.packet.s2c.AddChantS2CPacket;
import radon.jujutsu_kaisen.network.packet.s2c.ClearChantsC2SPacket;
import radon.jujutsu_kaisen.network.packet.s2c.SetOverlayMessageS2CPacket;
import radon.jujutsu_kaisen.network.packet.s2c.SyncMouthS2CPacket;

public class ServerChantHandler {
    private static final Map<UUID, Integer> timers = new HashMap<UUID, Integer>();
    private static final Map<UUID, List<String>> messages = new HashMap<UUID, List<String>>();
    private static final int CLEAR_INTERVAL = 200;

    public static List<String> getMessages(LivingEntity owner) {
        return messages.getOrDefault(owner.m_20148_(), List.of());
    }

    public static boolean onChant(LivingEntity owner, String word) {
        ISorcererData cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        Ability ability = cap.getAbility(word);
        if (ability != null) {
            ServerPlayer player;
            if (!messages.containsKey(owner.m_20148_())) {
                messages.put(owner.m_20148_(), new ArrayList());
            }
            ArrayList<String> chants = new ArrayList<String>(cap.getFirstChants(ability));
            List<String> latest = messages.get(owner.m_20148_());
            int index = 0;
            Iterator iter = chants.iterator();
            for (String chant : latest) {
                if (!iter.hasNext() || !chant.equals(iter.next())) break;
                ++index;
            }
            if (index >= chants.size() || !((String)chants.get(index)).equals(word)) {
                return true;
            }
            messages.get(owner.m_20148_()).add(word);
            if (owner instanceof ServerPlayer) {
                player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new AddChantS2CPacket(word), player);
            }
            timers.put(owner.m_20148_(), 200);
            if (owner instanceof ServerPlayer) {
                player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new SetOverlayMessageS2CPacket((Component)Component.m_237110_((String)String.format("chat.%s.chant", "jujutsu_kaisen"), (Object[])new Object[]{ability.getName().m_6881_(), Float.valueOf(ChantHandler.getOutput(owner, ability) * 100.0f)}), false), player);
            }
            if (cap.hasTrait(Trait.PERFECT_BODY)) {
                PacketHandler.broadcast(new SyncMouthS2CPacket(owner.m_20148_()));
            }
            return true;
        }
        return false;
    }

    @Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ChantHandlerForgeEvents {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            Iterator<Map.Entry<UUID, Integer>> iter = timers.entrySet().iterator();
            while (iter.hasNext()) {
                Ability ability;
                ISorcererData cap;
                ServerLevel level;
                Map.Entry<UUID, Integer> entry = iter.next();
                if (!messages.containsKey(entry.getKey())) {
                    iter.remove();
                    continue;
                }
                Entity owner = null;
                Iterator iterator = event.getServer().m_129785_().iterator();
                while (iterator.hasNext() && (owner = (level = (ServerLevel)iterator.next()).m_8791_(entry.getKey())) == null) {
                }
                if (owner == null || (cap = (ISorcererData)owner.getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow()).isChanneling(ability = cap.getAbility(new LinkedHashSet<String>((Collection)messages.get(entry.getKey()))))) continue;
                int remaining = entry.getValue();
                if (remaining > 0) {
                    timers.put(entry.getKey(), --remaining);
                    continue;
                }
                messages.remove(entry.getKey());
                iter.remove();
                if (!(owner instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)owner;
                PacketHandler.sendToClient(new ClearChantsC2SPacket(), player);
            }
        }

        @SubscribeEvent
        public static void onAbilityTrigger(AbilityTriggerEvent.Post event) {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            Ability ability = event.getAbility();
            if (ChantHandler.isChanted(event.getEntity(), ability) && ability.getActivationType(event.getEntity()) == Ability.ActivationType.INSTANT) {
                LivingEntity owner = event.getEntity();
                messages.remove(owner.m_20148_());
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    PacketHandler.sendToClient(new ClearChantsC2SPacket(), player);
                }
            }
        }

        @SubscribeEvent
        public static void onAbilityStop(AbilityStopEvent event) {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            Ability ability = event.getAbility();
            if (ChantHandler.isChanted(event.getEntity(), ability)) {
                LivingEntity owner = event.getEntity();
                messages.remove(owner.m_20148_());
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    PacketHandler.sendToClient(new ClearChantsC2SPacket(), player);
                }
            }
        }

        @SubscribeEvent
        public static void onServerChat(ServerChatEvent event) {
            ServerPlayer sender = event.getPlayer();
            String message = event.getRawText();
            ServerLevel level = sender.m_284548_();
            sender.getCapability(SorcererDataHandler.INSTANCE).ifPresent(cap -> {
                if (cap.hasSilenced()) {
                    event.setCanceled(true);
                    sender.m_5661_((Component)Component.m_237113_((String)"You are silenced and cannot speak!"), true);
                    return;
                }
                boolean sent = ServerChantHandler.onChant((LivingEntity)sender, message.toLowerCase());
                if (sent) {
                    event.setCanceled(true);
                    double radius = 256.0;
                    sender.m_213846_((Component)Component.m_237113_((String)("<" + sender.m_7755_().getString() + "> " + message)));
                    for (ServerPlayer other : level.m_6907_()) {
                        if (sender == other || !((double)other.m_20270_((Entity)sender) <= radius) || !other.m_9236_().m_46472_().equals((Object)sender.m_9236_().m_46472_())) continue;
                        other.m_213846_((Component)Component.m_237113_((String)("<" + sender.m_7755_().getString() + "> " + message)));
                    }
                }
            });
        }
    }
}

