/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.gui.overlay;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import radon.jujutsu_kaisen.util.HelperMethods;

@Mod.EventBusSubscriber(modid="jujutsu_kaisen", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ScreenFlashOverlay {
    private static final int DEFAULT_DURATION = 20;
    private static FlashEvent current;
    public static IGuiOverlay OVERLAY;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (current == null) {
            return;
        }
        --ScreenFlashOverlay.current.duration;
        if (ScreenFlashOverlay.current.duration <= 0) {
            current = null;
        }
    }

    public static void flash() {
        current = new FlashEvent(20);
    }

    static {
        OVERLAY = (gui, graphics, partialTicks, width, height) -> {
            if (current == null) {
                return;
            }
            float alpha = (float)ScreenFlashOverlay.current.duration / 20.0f;
            graphics.m_280509_(0, 0, width, height, HelperMethods.toRGB24(255, 255, 255, (int)(255.0f * alpha)));
        };
    }

    public static class FlashEvent {
        public int duration;

        public FlashEvent(int duration) {
            this.duration = duration;
        }
    }
}

