/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.client.particle.JJKParticleRenderTypes;
import radon.jujutsu_kaisen.client.particle.JJKParticles;

public class FireParticle
extends TextureSheetParticle {
    private final float size;

    protected FireParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, FireParticleOptions options) {
        super(pLevel, pX, pY, pZ);
        this.f_107225_ = options.lifetime();
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.size = Math.max(options.scalar(), (this.f_107223_.m_188501_() - 0.5f) * options.scalar());
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107663_ = this.size * (1.0f - (float)this.f_107224_ / (float)this.f_107225_);
    }

    private void fireVertex(PoseStack.Pose pMatrixEntry, VertexConsumer pBuffer, float pX, float pY, float pZ, float pTexU, float pTexV) {
        pBuffer.m_252986_(pMatrixEntry.m_252922_(), pX, pY, pZ).m_6122_(255, 255, 255, 255).m_7421_(pTexU, pTexV).m_7122_(0, 10).m_85969_(0xF000F0).m_252939_(pMatrixEntry.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack stack = new PoseStack();
        double d0 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double d1 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double d2 = Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_);
        Vec3 cam = pRenderInfo.m_90583_();
        stack.m_85836_();
        stack.m_85837_(d0 - cam.f_82479_, d1 - cam.f_82480_, d2 - cam.f_82481_);
        TextureAtlasSprite fire0 = ModelBakery.f_119219_.m_119204_();
        TextureAtlasSprite fire1 = ModelBakery.f_119220_.m_119204_();
        float f = this.f_107663_ * 1.4f;
        stack.m_85841_(f, f, f);
        float f1 = 0.5f;
        float f3 = this.f_107663_ / f;
        float f4 = 0.0f;
        stack.m_252781_(Axis.f_252392_.m_252977_(pRenderInfo.m_90590_()));
        stack.m_252880_(0.0f, 0.0f, -0.3f + (float)((int)f3) * 0.02f);
        float f5 = 0.0f;
        int i = 0;
        VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(Sheets.m_110790_());
        PoseStack.Pose posestack$pose = stack.m_85850_();
        while (f3 > 0.0f) {
            TextureAtlasSprite sprite = i % 2 == 0 ? fire0 : fire1;
            float f6 = sprite.m_118409_();
            float f7 = sprite.m_118411_();
            float f8 = sprite.m_118410_();
            float f9 = sprite.m_118412_();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            this.fireVertex(posestack$pose, consumer, f1 - 0.0f, 0.0f - f4, f5, f8, f9);
            this.fireVertex(posestack$pose, consumer, -f1 - 0.0f, 0.0f - f4, f5, f6, f9);
            this.fireVertex(posestack$pose, consumer, -f1 - 0.0f, 1.4f - f4, f5, f6, f7);
            this.fireVertex(posestack$pose, consumer, f1 - 0.0f, 1.4f - f4, f5, f8, f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        stack.m_85849_();
        mc.m_91269_().m_110104_().m_109911_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return JJKParticleRenderTypes.CUSTOM;
    }

    public record FireParticleOptions(float scalar, boolean glow, int lifetime) implements ParticleOptions
    {
        public static ParticleOptions.Deserializer<FireParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<FireParticleOptions>(){

            @NotNull
            public FireParticleOptions fromCommand(@NotNull ParticleType<FireParticleOptions> type, @NotNull StringReader reader) throws CommandSyntaxException {
                return new FireParticleOptions(reader.readFloat(), reader.readBoolean(), reader.readInt());
            }

            @NotNull
            public FireParticleOptions fromNetwork(@NotNull ParticleType<FireParticleOptions> type, @NotNull FriendlyByteBuf buf) {
                return new FireParticleOptions(buf.readFloat(), buf.readBoolean(), buf.readInt());
            }
        };

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)JJKParticles.FIRE.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeFloat(this.scalar);
            buf.writeBoolean(this.glow);
            buf.writeInt(this.lifetime);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %b %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.scalar), this.glow, this.lifetime);
        }
    }

    public static class Provider
    implements ParticleProvider<FireParticleOptions> {
        public Provider(SpriteSet ignored) {
        }

        public FireParticle createParticle(@NotNull FireParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FireParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options);
        }
    }
}

