/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.client.render.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import radon.jujutsu_kaisen.client.JJKRenderTypes;
import radon.jujutsu_kaisen.entity.projectile.FireArrowProjectile;

public class FireArrowRenderer
extends EntityRenderer<FireArrowProjectile> {
    private static final int TEXTURE_WIDTH = 32;
    private static final int STARTUP_TEXTURE_HEIGHT = 256;
    private static final int STILL_TEXTURE_HEIGHT = 128;
    private static final ResourceLocation STARTUP = new ResourceLocation("jujutsu_kaisen", "textures/entity/fire_arrow_startup.png");
    private static final ResourceLocation STILL = new ResourceLocation("jujutsu_kaisen", "textures/entity/fire_arrow.png");

    public FireArrowRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(@NotNull FireArrowProjectile pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Minecraft mc = Minecraft.m_91087_();
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.0f, pEntity.m_20206_() / 2.0f, 0.0f);
        float yaw = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19859_, (float)pEntity.m_146908_());
        float pitch = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(yaw - 90.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pitch));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        pPoseStack.m_85841_(1.5f, 1.5f, 1.5f);
        boolean still = (float)pEntity.getTime() + pPartialTick >= 20.0f;
        RenderType type = JJKRenderTypes.glow(still ? STILL : STARTUP);
        VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(type);
        Matrix4f pose = pPoseStack.m_85850_().m_252922_();
        int frame = Mth.m_14143_((float)(((float)(pEntity.animation - 1) + pPartialTick) * 2.0f));
        if (frame < 0) {
            frame = (still ? 2 : 4) * 2;
        }
        float minU = 0.0f;
        float minV = 32.0f / (float)(still ? 128 : 256) * (float)frame;
        float maxU = minU + 1.0f;
        float maxV = minV + 32.0f / (float)(still ? 128 : 256);
        consumer.m_252986_(pose, -1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, -1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, 1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF00000).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        mc.m_91269_().m_110104_().m_109912_(type);
        pPoseStack.m_85849_();
    }

    protected int getBlockLightLevel(@NotNull FireArrowProjectile pEntity, @NotNull BlockPos pPos) {
        return 15;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FireArrowProjectile pEntity) {
        return TextureAtlas.f_118259_;
    }
}

