/*
 * Decompiled with CFR 0.152.
 */
package radon.jujutsu_kaisen.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import radon.jujutsu_kaisen.ability.JJKAbilities;
import radon.jujutsu_kaisen.ability.base.Ability;
import radon.jujutsu_kaisen.capability.data.sorcerer.ISorcererData;
import radon.jujutsu_kaisen.capability.data.sorcerer.SorcererDataHandler;
import radon.jujutsu_kaisen.entity.JJKEntities;

public class HollowWickerBasketEntity
extends Entity {
    private static final float STRENGTH = 100.0f;
    private static final double X_STEP = 0.025;
    public static final float RADIUS = 1.25f;
    private static final float MAX_RADIUS = 4.0f;
    private static final float DAMAGE = 3.0f;
    private boolean invuln = false;
    private boolean domainInvuln = false;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity cachedOwner;

    protected HollowWickerBasketEntity(EntityType<?> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.m_20256_(Vec3.f_82478_);
    }

    public HollowWickerBasketEntity(LivingEntity owner) {
        super((EntityType)JJKEntities.HOLLOW_WICKER_BASKET.get(), owner.m_9236_());
        this.setOwner(owner);
        this.m_146884_(owner.m_20182_());
    }

    public boolean m_5825_() {
        return true;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        float radius = 1.25f;
        return EntityDimensions.m_20398_((float)radius, (float)radius);
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount, boolean isDomainAttack) {
        LivingEntity attacker;
        if (!isDomainAttack && this.invuln) {
            return false;
        }
        if (isDomainAttack && this.domainInvuln) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && (attacker = (LivingEntity)entity) == this.getOwner()) {
            return false;
        }
        ISorcererData cap = (ISorcererData)this.getOwner().getCapability(SorcererDataHandler.INSTANCE).resolve().orElseThrow();
        if (isDomainAttack) {
            this.domainInvuln = true;
            cap.delayTickEvent(() -> {
                this.domainInvuln = false;
            }, 10);
        }
        if (!isDomainAttack) {
            this.invuln = true;
            cap.delayTickEvent(() -> {
                this.invuln = false;
            }, 5);
        }
        return true;
    }

    public void m_8119_() {
        this.m_6210_();
        LivingEntity owner = this.getOwner();
        if (!(this.m_9236_().f_46443_ || owner != null && !owner.m_213877_() && owner.m_6084_() && JJKAbilities.hasToggled(owner, (Ability)JJKAbilities.HOLLOW_WICKER_BASKET.get()))) {
            this.m_146870_();
        } else if (owner != null) {
            super.m_8119_();
            this.m_146884_(owner.m_20182_());
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = (LivingEntity)((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.m_128362_("owner", this.ownerUUID);
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        if (pCompound.m_128403_("owner")) {
            this.ownerUUID = pCompound.m_128342_("owner");
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        LivingEntity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? 0 : entity.m_19879_());
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        LivingEntity owner = (LivingEntity)this.m_9236_().m_6815_(pPacket.m_131509_());
        if (owner != null) {
            this.setOwner(owner);
        }
    }

    protected void m_8097_() {
    }
}

